#include<bits/stdc++.h>
#define pb push_back

using namespace std;

typedef long long ll;
typedef pair<int, int> pii;

const int maxn=1e6+3;
const int mod=1e9+7;

int n, m;
vector<int> nbrs[maxn];
int par[maxn], rankk[maxn];
bool vis[maxn];
bool color[maxn];

bool dfs(int x, int y, bool col, int comp){
    vis[x]=true;
    color[x]=col;
    par[x]=comp;
    rankk[comp]++;

    for(auto u: nbrs[x]){
        if(u==y or u==x) continue;
        if(vis[u] and color[u]==col) return false;
        if(!vis[u]){
            return dfs(u, x, !col, comp);
        }
    }

    return true;
}

bool check(){
    for(int i=1; i<=n; i++){
        if(!vis[i]){
            bool curr=dfs(i, 0, 0, i);
            if(!curr) return false;
        }
    }
    return true;
}

int findd(int x){
    if(par[x]==x){
        return x;
    }

    return par[x]=findd(par[x]);
}

void unite(int x, int y){
    bool smen=false;
    if(color[x]==color[y]) smen=true;

    x=findd(x);
    y=findd(y);

    if(rankk[x]<rankk[y]) swap(x, y);

    if(smen){
        for(int i=1; i<=n; i++){
            if(findd(i)==y) color[i]=!color[i];
        }
    }

    par[y]=par[x];

    return ;
}

int main(){
ios_base::sync_with_stdio(false);
cin.tie(NULL);
cout.tie(NULL);

int q;
cin>>n>>m>>q;

for(int i=0; i<m; i++){
    int a, b;
    cin>>a>>b;
    nbrs[a].pb(b);
    nbrs[b].pb(a);
}

if(!check()){
    cout<<-1<<endl;
    return 0;
}

int ans=0;

for(int i=1; i<=q; i++){
    int a, b;
    cin>>a>>b;

    if(findd(a)==findd(b) and a!=b){
        if(color[a]==color[b]){
            ans=i;
        }
    }else{
        unite(a, b);
    }
}

if(ans!=0){
    cout<<ans<<endl;
    return 0;
}
cout<<-2<<endl;
return 0;
}

