#include <iostream>
#include <vector>
#include <map>
using namespace std;
const int MAXN = 2 * 1e5 + 1;
int color[MAXN];
bool visited[MAXN];
int root[MAXN];
int bigness[MAXN];
bool adjoined[MAXN];
vector<int> neighbours[MAXN];
map< pair<int, int>, int > par;
bool bfs(int curr, int prev, int colour, bool parity) {
    visited[curr] = true;
    root[curr] = root[prev];
    if (color[curr] == 0) {
        par[{root[curr], curr}] = parity;
        bigness[root[curr]]++;
        color[curr] = colour;
        for (auto it : neighbours[curr]) {
            if (it == prev || it == curr) {
                continue;
            }
            if (!bfs(it, curr, -colour, !parity)) {
                return false;
            }
        }
        return true;
    } else {
        if (color[curr] == colour) {
            return true;
        } else {
//            cout << curr << ' ' << prev << ' ' << color[curr] << '\n';
            return false;
        }
    }
}
void adj(int curr, int prev, int a, int b) {
    if (adjoined[curr]) {
        return;
    }
    adjoined[curr] = true;
    par[{root[a], curr}] = (par[{root[a], a}] + par[{root[b], b}] + par[{root[b], curr}] + 1) % 2;
//    cout << root[a] << ' ' << a << ' ' << root[b] << ' ' << b << ' ' << curr << '\n';
//    cout << par[{root[a], a}] << ' ' << par[{root[b], b}] << ' ' << par[{root[b], curr}] << ' ' << par[{root[a], curr}] << '\n';
    for (auto it : neighbours[curr]) {
        if (it != prev && it != curr) {
            adj(it, curr, a, b);
        }
    }
}
void clean(int curr, int prev) {
    root[curr] = root[prev];
    if (adjoined[curr]) {
        adjoined[curr] = false;
        for (auto it : neighbours[curr]) {
            if (it != curr && it != prev) {
                clean(it, curr);
            }
        }
    } else {
        return;
    }
}
int main() {
    ios_base::sync_with_stdio(false);
    cin.tie(0);
    cout.tie(0);

    int n, m, q;
    cin >> n >> m >> q;
    for (int i = 1; i <= n; i++) {
        color[i] = 0;
        visited[i] = false;
        bigness[i] = 0;
        adjoined[i] = false;
    }
    for (int i = 1; i <= m; i++) {
        int a, b;
        cin >> a >> b;
        neighbours[a].push_back(b);
        neighbours[b].push_back(a);
    }
    for (int i = 1; i <= n; i++) {
        if (!visited[i]) {
            root[0] = i;
            if (!bfs(i, 0, 1, 0)) {
                cout << -1;
                return 0;
            }
        }
    }
    for (int i = 1; i <= q; i++) {
        int a, b;
        cin >> a >> b;
        if (a == b) {
            continue;
        }
        if (root[a] == root[b]) {
            if (par[{root[a], a}] == par[{root[b], b}]) {
                cout << i;
                return 0;
            }
        } else {
            if (bigness[root[a]] < bigness[root[b]]) {
                swap(a, b);
            }
            adj(root[b], 0, a, b);
            root[0] = root[a];
            clean(root[b], 0);
            bigness[root[a]] += bigness[root[b]];
            neighbours[a].push_back(b);
            neighbours[b].push_back(a);
        }
    }
    cout << -2;
    return 0;
}

