#include <bits/stdc++.h>
using namespace std;

int n, m, q;
const int MAX_N = 200000 + 7;
vector<int> graph[MAX_N];
vector< pair<int, int> > edges;
bool visited[MAX_N];

bool group[MAX_N];
int component[MAX_N];
int currComponent = 0;

void dfs(int node) {
    visited[node] = true;
    component[node] = currComponent;
    for(int i = 0; i < graph[node].size(); i++) {
        if(!visited[graph[node][i]]) {
            group[graph[node][i]] = !group[node];
            dfs(graph[node][i]);
        }
    }
}


int main() {
    ios_base::sync_with_stdio(false);
    cin.tie(0);
    cout.tie(0);

    cin >> n >> m >> q;


    bool impossible = false;
    for(int i = 0; i < m; i++) {
        int u, v;
        cin >> u >> v;
        u--;
        v--;
        if(u == v) {
            impossible = true;
        }
        graph[u].push_back(v);
        graph[v].push_back(u);
        edges.push_back({u, v});
    }

    /*if(impossible) {
        cout << -1;
        return 0;
    }*/

    for(int i = 0; i < n; i++) {
        visited[i] = false;
        group[i] = false;
        component[i] = 0;
    }

    for(int i = 0; i < n; i++) {
        if(!visited[i]) {
            dfs(i);
            currComponent++;
        }
    }

    for(int i = 0; i < m; i++) {
        if(group[edges[i].first] == group[edges[i].second]) {
            impossible = true;
            //cout << -1;
            //return 0;
        }
    }

    for(int i = 0; i < n; i++) {
        visited[i] = false;
    }


    int x = 0;
    bool notBipartite = false;

    for(int j = 0; j < q; j++) {
        int u, v;
        cin >> u >> v;
        u--;
        v--;
        if(notBipartite) {
            continue;
        }
        if(component[u] == component[v]) {
            if(group[u] == group[v]) {
                notBipartite = true;
                x = j + 1;
            }
            graph[u].push_back(v);
            graph[v].push_back(u);
            edges.push_back({u, v});
        }
        else
        {
            group[v] = !group[u];
            currComponent = component[u];
            dfs(v);
            graph[u].push_back(v);
            graph[v].push_back(u);
            edges.push_back({u, v});
        }
    }
    if(impossible) {
        cout << -1;
        return 0;
    }
    if(notBipartite) {
        cout << x;
    }
    else
    {
        cout << -2;
    }
    return 0;
}
