#include <algorithm>
#include <iostream>
#include <numeric>
#include <cassert>
#include <vector>

typedef long long llong;
const int MAXN = 1e6 + 10;
const int INF  = 1e9;

int n, m, q;
int part[MAXN];
int from[MAXN], to[MAXN];

struct DSU
{
    int part[MAXN];
    int par[MAXN];
    int dep[MAXN];

    void build()
    {
        std::fill(part + 1, part + 1 + n, 0);
        std::iota(par + 1, par + 1 + n, 1);
        std::fill(dep + 1, dep + 1 + n, 1);
    }

    int find(int node)
    {
        if (par[node] == node)
        {
            return node;
        }

        int res = find(par[node]);
        part[node] ^= part[par[node]];
        return par[node] = res;
    }

    void connect(int u, int v)
    {

        find(u);
        find(v);
        int part_diff = part[u] ^ part[v];
        u = par[u]; v = par[v];

        if (u == v)
        {
            return;
        }

        if (dep[u] < dep[v])
        {
            std::swap(u, v);
        }

        if (dep[u] == dep[v])
        {
            dep[v]++;
        }

        par[u] = v;
        part[u] = 1 ^ part_diff;
    }

    bool check(int u, int v)
    {
        if (find(u) != find(v) || part[u] != part[v])
        {
            return true;
        }

        return false;
    }
};

DSU dsu;
void solve()
{
    dsu.build();
    for (int i = 1 ; i <= m ; ++i)
    {
        if (!dsu.check(from[i], to[i]))
        {
            std::cout << -1 << '\n';
            return;
        }

        dsu.connect(from[i], to[i]);
    }

    for (int i = m + 1 ; i <= m + q ; ++i)
    {
        if (!dsu.check(from[i], to[i]))
        {
            std::cout << i - m << '\n';
            return;
        }

        dsu.connect(from[i], to[i]);
    }

    std::cout << -2 << '\n';
}

void input()
{
    std::cin >> n >> m >> q;
    for (int i = 1 ; i <= m ; ++i)
    {
        std::cin >> from[i] >> to[i];
    }

    for (int i = 1 ; i <= q ; ++i)
    {
        std::cin >> from[m + i] >> to[m + i];
    }
}

void fastIOI()
{
    std::ios_base :: sync_with_stdio(0);
    std::cout.tie(nullptr);
    std::cin.tie(nullptr);
}

int main()
{
    fastIOI();
    input();
    solve();

    return 0;
}