#include <algorithm>
#include <iostream>
#include <numeric>
#include <cassert>
#include <vector>

typedef long long llong;
const int MAXN = 1e6 + 10;
const int INF  = 1e9;

int n, m, q;
int part[MAXN];
int from[MAXN], to[MAXN];
std::vector <int> g[MAXN];

bool dfs(int node)
{
    for (const int &u : g[node])
    {
        if (part[u] == part[node])
        {
            return false;
        }

        if (part[u] == 0)
        {
            part[u] = 3 ^ part[node];
            if (!dfs(u)) return false;
        }
    }

    return true;
}

bool check(int t)
{
    for (int i = 1 ; i <= n ; ++i)
    {
        g[i].clear();
        part[i] = 0;
    }

    for (int i = 1 ; i <= t ; ++i)
    {
        g[from[i]].push_back(to[i]);
        g[to[i]].push_back(from[i]);
    }

    for (int i = 1 ; i <= n ; ++i)
    {
        if (part[i] == 0)
        {
            part[i] = 1;
            if (!dfs(i)) return false;
        }
    }

    return true;
}

void solve()
{
    if (!check(m))
    {
        std::cout << -1 << '\n';
        return;
    }

    int l = m, r = m + q + 1, mid;
    while (l < r - 1)
    {
        mid = l + r >> 1;
        if (check(mid)) l = mid;
        else r = mid;
    }

    if (r == m + q + 1) std::cout << -2 << '\n';
    else std::cout << r - m << '\n';
}

void input()
{
    std::cin >> n >> m >> q;
    for (int i = 1 ; i <= m ; ++i)
    {
        std::cin >> from[i] >> to[i];
    }

    for (int i = 1 ; i <= q ; ++i)
    {
        std::cin >> from[m + i] >> to[m + i];
    }
}

void fastIOI()
{
    std::ios_base :: sync_with_stdio(0);
    std::cout.tie(nullptr);
    std::cin.tie(nullptr);
}

int main()
{
    fastIOI();
    input();
    solve();

    return 0;
}