#include <algorithm>
#include <iostream>
#include <numeric>
#include <cassert>
#include <vector>

typedef long long llong;
const int MAXP = 1e6 + 10;
const int MAX = 1e7 + 10;
const int INF  = 1e9;

int n;
bool bl[MAXP];
bool is_composite[MAX];
std::vector <int> primes;

void solve()
{
    for (int i = 2 ; i * i < MAXP ; ++i)
    {
        if (!bl[i])
        {
            primes.push_back(i);
            for (int j = i * i ; j < MAXP ; j += i)
            {
                bl[j] = true;
            }
        }
    }

    for (int i = 1 ; i <= n ; ++i)
    {
        llong l, r;
        std::cin >> l >> r;
        if (l == 1) l++;

        std::fill(is_composite, is_composite + r - l + 1, 0);
        for (const int &p : primes)
        {
            if (1LL * p * p > r)
            {
                break;
            }

            llong first = std::max(l, 1LL * p * p);
            if (l % p != 0)
            {
                first = std::max(first, l + p - (l % p));   
            }

            for (llong j = first ; j <= r ; j += p)
            {
                is_composite[j - l] = true;
            }
        }

        int ans = 0;
        for (int i = 0 ; i < r - l + 1 ; ++i)
        {
            ans += !is_composite[i];
        }

        std::cout << ans << '\n';
    }
}

void input()
{
    std::cin >> n;;
}

void fastIOI()
{
    std::ios_base :: sync_with_stdio(0);
    std::cout.tie(nullptr);
    std::cin.tie(nullptr);
}

int main()
{
    fastIOI();
    input();
    solve();

    return 0;
}