#include <algorithm>
#include <iostream>
#include <numeric>
#include <cassert>
#include <vector>

typedef long long llong;
const int MAXN = 21;
const int MAXP = 1e6 + 10;
const int INF  = 1e9;

int n, m, p;
int a[MAXN][MAXN];
llong dp[2][MAXN][MAXP];

void solve()
{
    dp[0][1][0] = 1;
    for (int i = 1 ; i <= n ; ++i)
    {
        for (int j = 1 ; j <= m ; ++j)
        {
            for (int rem = 0 ; rem < p ; ++rem)
            {
                int value = rem - a[i][j];
                if (value < 0) value += p;
                dp[i & 1][j][rem] = dp[i & 1][j - 1][value] + dp[(i & 1) ^ 1][j][value];
            }
        }
    }

    std::cout << dp[n & 1][m][0] << '\n';
}

void input()
{
    std::cin >> n >> m >> p;
    for (int i = 1 ; i <= n ; ++i)
    {
        for (int j = 1 ; j <= m ; ++j)
        {
            std::cin >> a[i][j];
            if (a[i][j] > 0) a[i][j] %= p;
            else a[i][j] = ((-a[i][j]) % p == 0 ? 0 : p - ((-a[i][j]) % p));
        }
    }
}

void fastIOI()
{
    std::ios_base :: sync_with_stdio(0);
    std::cout.tie(nullptr);
    std::cin.tie(nullptr);
}

int main()
{
    fastIOI();
    input();
    solve();

    return 0;
}