#include<bits/stdc++.h>
#define MAXN 200007
#define MAXQ 400007
using namespace std;

int n,m,q,a,b;
vector<int> v[MAXN];
pair<int,int> e[MAXQ];

bool li[MAXN];
int side[MAXN];

bool dfs(int x,int s){
    side[x]=s;
    li[x]=true;

    for(int i:v[x]){
        if(!li[i]){
            if(!dfs(i,1-s))return false;
        }else{
            if(side[i]==side[x])return false;
        }
    }

    return true;
}

bool bipartite(){
    for(int i=1;i<=n;i++)li[i]=false;

    for(int i=1;i<=n;i++){
        if(li[i])continue;
        if(!dfs(i,0))return false;
    }

    return true;
}

void prefix(int x){
    for(int i=1;i<=x;i++){
        v[e[i].first].push_back(e[i].second);
        v[e[i].second].push_back(e[i].first);
    }
}

void undo(int x){
    for(int i=1;i<=x;i++){
        v[e[i].first].pop_back();
        v[e[i].second].pop_back();
    }
}

int bin(){
    int l=0,r=q+1,tt;

    while(l+1<r){
        tt=(l+r)/2;

        prefix(tt);
        if(bipartite()){
            l=tt;
        }else{
            r=tt;
        }

        undo(tt);
    }

    if(l<q)return l+1;
    return -2;
}

int main(){
    
    ios_base::sync_with_stdio(0);
    cin.tie(0);
    cout.tie(0);

    cin>>n>>m>>q;
    for(int i=1;i<=m;i++){
        cin>>a>>b;
        v[a].push_back(b);
        v[b].push_back(a);
    }

    if(!bipartite()){
        cout<<"-1\n";
        return 0;
    }

    for(int i=1;i<=q;i++){
        cin>>e[i].first>>e[i].second;
    }

    cout<<bin()<<"\n";

    return 0;
}

