#include <iostream>

using biggie = long long;

bool is_prime(biggie n)noexcept {
	if (n <= 3) {
		return n > 1;
	}
	if (n % 2 == 0 || n % 3 == 0) {
		return false;
	}
	biggie d;
	for (d = 5; d * d <= n; ++d) {
		if (n % d == 0 || n % (d + 2) == 0) {
			return false;
		}
	}
	return true;
}

int main() {
	// 1
	biggie n;
	std::cin >> n;
	// 2
	biggie i, a, b;
	for (i = 5 + (n - 5) / 6 * 6; i > 1; i -= 6) {
		b = i;
		a = n + b;
		if (is_prime(b) && is_prime(a)) {
			std::cout << a << ' ' << b << '\n';
			return 0;
		}
		b = i + 2;
		a = n + b;
		if (b < n && is_prime(b) && is_prime(a)) {
			std::cout << a << ' ' << b + 2 << '\n';
			return 0;
		}
	}
	// 3
	if (is_prime(a = n + 2)) {
		std::cout << a << ' ' << 2 << '\n';
	}
	return 0;
}
