#include <bits/stdc++.h>
using namespace std;
bool isPrime(int num)
{
    if (num <= 1) return false;
    if (num <= 3) return true;
    if (num % 2 == 0 || num % 3 == 0) return false;
    for (int i = 5; i * i <= num; i += 6)
    {
        if (num % i == 0 || num % (i + 2) == 0) return false;
    }
    return true;
}
vector<int> findDivisors(int N)
{
    vector<int> divisors;
    for (int i = 1; i <= sqrt(N); i++)
    {
        if (N % i == 0)
        {
            divisors.push_back(i);
            if (i != N / i) divisors.push_back(N / i);
        }
    }
    return divisors;
}
bool canBeConsecutive(int a, int b)
{
    if (a > b && a % b == 0 && isPrime(a / b)) return true;
    if (a < b && b % a == 0 && isPrime(b / a)) return true;
    return false;
}
void findAndPrintSequence(int N)
{
    vector<int> divisors = findDivisors(N);
    sort(divisors.begin(), divisors.end());
    vector<int> sequence;
    sequence.push_back(N);

    for (int i = divisors.size() - 1; i >= 0; --i)
    {
        if (canBeConsecutive(sequence.back(), divisors[i]))
        {
            sequence.push_back(divisors[i]);
        }
    }
    for (int num : sequence)
    {
        cout << num << " ";
    }
    cout << endl;
}

int main()
{
    int N;
    cin >> N;
    findAndPrintSequence(N);
    return 0;
}
