/**
 ____ ____ ____ ____ ____ ____
||l |||e |||i |||n |||a |||d ||
||__|||__|||__|||__|||__|||__||
|/__\|/__\|/__\|/__\|/__\|/__\|

**/

#include<bits/stdc++.h>
#define endl '\n'

using namespace std;
typedef long long ll;

void speed()
{
    ios_base::sync_with_stdio(false);
    cin.tie(NULL);
    cout.tie(NULL);
}

const ll inf = 1e18;
const int maxn = 3010;

struct edge
{
    int u;
    ll w;

    edge(int _u = 0, ll _w = 0)
    {
        u = _u;
        w = _w;
    }

    bool operator < (const edge &e) const
    {
        return w > e.w;
    }
};

int n, m, k, used[maxn];
ll dist[maxn];
vector < edge > g[maxn];
void solve()
{
    cin >> n >> m >> k;
    set < ll > pos;
    for (int i = 1; i <= m; i ++)
    {
        int v, u;
        ll w;
        cin >> v >> u >> w;
        g[v].push_back(edge(u, w));
        g[u].push_back(edge(v, w));
        pos.insert(w);
    }

    pos.insert(0);

    ll ans = inf;
    for (ll val : pos)
    {
        for (int i = 1; i <= n; i ++)
            dist[i] = inf, used[i] = 0;

        dist[1] = 0;
        priority_queue < edge > pq;
        pq.push(edge(1, 0));

        while(!pq.empty())
        {
            edge cur = pq.top();
            pq.pop();
            if (!used[cur.u])
            {
                used[cur.u] = 1;
                for (int i = 0; i < g[cur.u].size(); i ++)
                {
                    edge nb = g[cur.u][i];
                    nb.w = max(nb.w - val, (ll)(0));
                    nb.w += cur.w;
                    if (nb.w < dist[nb.u])
                    {
                        dist[nb.u] = nb.w;
                        pq.push(nb);
                    }
                }
            }
        }

        ans = min(ans, dist[n] + k * val);
    }

    cout << ans << endl;

}

int main()
{
    solve();
    return 0;
}

