#include <unordered_map>
#include <algorithm>
#include <iostream>
#include <numeric>
#include <cstring>
#include <cassert>
#include <vector>
#include <queue>
#include <map>

typedef long long llong;
const short MAXN = 3000 + 10;
const llong INF = 1e18;

short n;
char s[MAXN];
short cnt[MAXN];
short cntL[MAXN];
short cntR[MAXN];
short badWithD[MAXN][MAXN];
std::vector <short> divs[MAXN];
short prefixL[MAXN][MAXN];
short prefixR[MAXN][MAXN];
short prefixU[MAXN];
short prefixD[MAXN];
std::map <std::pair <short,short>,short> nextMap;
bool calced[MAXN];
short cntRL[MAXN];
short next[MAXN];

void calcForD(int d)
{
    if (calced[d])
    {
        return;
    }

    calced[d] = true;
    std::fill(badWithD[d], badWithD[d] + n + 1, n + 1);
    for (short i = 1 ; i <= n ; ++i) // LRUD
    {
        for (short mask = 0 ; mask < 16 ; ++mask)
        {
            if (__builtin_popcount(mask) != 2)
            {
                continue;
            }

            short l = i, r = i;
            bool isOk = true;
            if ((mask & 1) && (i == 1 || s[i - 1] != 'R')) isOk = false;
            else if (mask & 1) l = i - 1;

            if ((mask & 2) && (i == n || s[i + 1] != 'L')) isOk = false;
            else if (mask & 2) r = i + 1;

            if ((mask & 4) && (i < d || s[i - d] != 'D')) isOk = false;
            else if (mask & 4) l = i - d;

            if ((mask & 8) && (i > n - d || s[i + d] != 'U')) isOk = false;
            else if (mask & 8) r = i + d;

            if (isOk) 
            {
                badWithD[d][l] = std::min(badWithD[d][l], r);
            }
        }
    }

    for (short i = n - 1 ; i >= 1 ; --i)
    {
        badWithD[d][i] = std::min(badWithD[d][i], badWithD[d][i + 1]);
    }
}

void solve()
{
    for (short i = 1 ; i <= n ; ++i)
    {
        prefixU[i] = prefixU[i - 1] + (s[i] == 'U');
        prefixD[i] = prefixD[i - 1] + (s[i] == 'D');
        cntL[i] = cntL[i - 1] + (s[i] == 'L');
        cntR[i] = cntR[i - 1] + (s[i] == 'R');
    }

    for (short i = 1 ; i <= n ; ++i)
    {
        for (short j = 1 ; j <= n ; ++j)
        {
            prefixL[i][j] = (s[i] == 'L') + prefixL[std::max(0, i - j)][j];
            prefixR[i][j] = (s[i] == 'R') + prefixR[std::max(0, i - j)][j];
        }
    }

    for (short i = 1 ; i + 1 < n ; ++i)
    {
        cntRL[i] = cntRL[i - 1] + (s[i] == 'R' && s[i + 2] == 'L');
    }

    for (short i = 1 ; i <= n ; ++i)
    {
        for (short j = i ; j <= n ; j += i)
        {
            divs[j].push_back(i);
        }
    }

    for (short i = n ; i >= 0 ; --i)
    {
        next[i] = nextMap[{prefixD[i] - prefixU[i], cntL[i] - cntR[i]}];
        nextMap[{prefixD[i] - prefixU[i], cntL[i] - cntR[i]}] = i;
    }

    int ans = 0;
    for (short l = 1 ; l <= n ; ++l)
    {
        for (short r = next[l - 1] ; r != 0 ; r = next[r])
        {
            if (r > l + 1 && cntRL[r - 2] - cntRL[l - 1] > 0)
            {
                continue;
            }

            bool can = false;
            for (const short &d : divs[r - l + 1])
            {
                if (prefixU[l + d - 1] - prefixU[l - 1] > 0)
                {
                    break;
                }

                if (prefixD[r] - prefixD[r - d] > 0)
                {
                    break;
                }

                short times = (r - l + 1) / d;
                if (prefixL[l + (times - 1) * d][d] - prefixL[std::max(0, l - d)][d] > 0)
                {
                    continue;
                }

                if (prefixR[l + (times - 1) * d + d - 1][d] - prefixR[std::max(0, l - 1)][d] > 0)
                {
                    continue;
                }

                calcForD(d);
                if (badWithD[d][l] <= r)
                {
                    continue;
                }

                can = true;
                break;
            }

            // if (can)
            // {
            //     std::cout << l << ' ' << r << '\n';
            // }
            ans += can;
        }
    }

    std::cout << ans << '\n';
}

void input()
{
    std::cin >> s + 1;
    n = strlen(s + 1);
}

void fastIOI()
{
    std::ios_base :: sync_with_stdio(0);
    std::cout.tie(nullptr);
    std::cin.tie(nullptr);
}

int main()
{
    fastIOI();
    input();
    solve();

    return 0;
}