#include <unordered_map>
#include <algorithm>
#include <iostream>
#include <numeric>
#include <cstring>
#include <cassert>
#include <vector>
#include <queue>

typedef long long llong;
const int MAXN = 6000 + 10;
const llong INF = 1e18;

int n;
char s[MAXN];
std::vector <int> divs[MAXN];
short cntL[MAXN];
short cntR[MAXN];
short prefixL[MAXN][MAXN];
short prefixR[MAXN][MAXN];
short prefixU[MAXN];
short prefixD[MAXN];

void solve()
{
    for (int i = 1 ; i <= n ; ++i)
    {
        prefixU[i] = prefixU[i - 1] + (s[i] == 'U');
        prefixD[i] = prefixD[i - 1] + (s[i] == 'D');
        cntL[i] = cntL[i - 1] + (s[i] == 'L');
        cntR[i] = cntR[i - 1] + (s[i] == 'R');
    }

    for (int i = 1 ; i <= n ; ++i)
    {
        for (int j = 1 ; j <= n ; ++j)
        {
            prefixL[i][j] = (s[i] == 'L') + prefixL[std::max(0, i - j)][j];
            prefixR[i][j] = (s[i] == 'R') + prefixR[std::max(0, i - j)][j];
        }
    }

    for (int i = 1 ; i <= n ; ++i)
    {
        for (int j = i ; j <= n ; j += i)
        {
            divs[j].push_back(i);
        }
    }

    int ans = 0;
    for (int l = 1 ; l <= n ; ++l)
    {
        for (int r = l ; r <= n ; ++r)
        {
            if (prefixD[r] - prefixD[l - 1] != prefixU[r] - prefixU[l - 1])
            {
                continue;
            }

            if (cntL[r] - cntL[l - 1] != cntR[r] - cntR[l - 1])
            {
                continue;
            }

            bool can = false;
            for (const int &d : divs[r - l + 1])
            {
                if (prefixU[l + d - 1] - prefixU[l - 1] > 0)
                {
                    break;
                }

                if (prefixD[r] - prefixD[r - d] > 0)
                {
                    break;
                }

                int times = (r - l + 1) / d;
                if (prefixL[l + (times - 1) * d][d] - prefixL[std::max(0, l - d)][d] > 0)
                {
                    continue;
                }

                if (prefixR[l + (times - 1) * d + d - 1][d] - prefixR[std::max(0, l - 1)][d] > 0)
                {
                    continue;
                }

                can = true;
                break;
            }

            ans += can;
        }
    }

    std::cout << ans  << '\n';
}

void input()
{
    std::cin >> s + 1;
    n = strlen(s + 1);
}

void fastIOI()
{
    std::ios_base :: sync_with_stdio(0);
    std::cout.tie(nullptr);
    std::cin.tie(nullptr);
}

int main()
{
    fastIOI();
    input();
    solve();

    return 0;
}