#include <unordered_map>
#include <algorithm>
#include <iostream>
#include <numeric>
#include <cassert>
#include <vector>
#include <queue>

typedef long long llong;
const int MAXN = 200000 + 10;
const llong INF = 1e18;

int n;
llong t[3][MAXN];
llong p[3][MAXN];
llong next[3][MAXN];
int nextComplete[3][MAXN];
llong sum[MAXN];
int dp[MAXN][3];

int run(llong value)
{
    for (int i = 1 ; i <= n ; ++i)
    {
        t[1][i] *= 2 * n;
        t[2][i] *= 2 * n;
        t[1][i] -= value;
        t[2][i] -= value;
    }

    for (int i = 1 ; i <= n ; ++i)
    {
        p[1][i] = p[1][i - 1] + t[1][i];
        p[2][i] = p[2][i - 1] + t[2][i];
        sum[i] = p[1][i] + p[2][i];
    }

    // std::cout << "t\n";
    // for (int i = 1 ; i <= n ; ++i)
    // {
    //     std::cout << t[1][i] << ' ';
    // }

    // std::cout << '\n';
    // for (int i = 1 ; i <= n ; ++i)
    // {
    //     std::cout << t[2][i] << ' ';
    // }

    // std::cout << '\n';

    std::unordered_map <double,int> up, down;
    up[0] = n + 1;
    down[0] = n + 1;
    for (int i = n ; i >= 1 ; --i)
    {
        up[p[1][i]] = i;
        down[p[2][i]] = i;
        next[1][i] = (up.count(p[1][i - 1]) ? up[p[1][i - 1]] : n + 1);
        next[2][i] = (down.count(p[2][i - 1]) ? down[p[2][i - 1]] : n + 1);
        nextComplete[1][i] = (up.count(-sum[i - 1] + p[1][i - 1]) ? up[-sum[i - 1] + p[1][i - 1]] : n + 1);
        nextComplete[2][i] = (down.count(-sum[i - 1] + p[2][i - 1]) ? down[-sum[i - 1] + p[2][i - 1]] : n + 1);
    }

    dp[n + 1][0] = dp[n + 1][1] = dp[n + 1][2] = 0;
    for (int idx = n ; idx >= 1 ; --idx)
    {
        for (int state = 0 ; state < 3 ; ++state)
        {
            if (state == 0)
            {
                if (sum[idx - 1] == 0)
                {
                    dp[idx][state] = 1 + dp[idx + 1][0];
                    if (next[1][idx] == next[2][idx] && next[1][idx] < n + 1)
                    {
                        // std::cout << "1\n";
                        dp[idx][state] = std::max(dp[idx][state], 2 + dp[next[1][idx] + 1][0]);
                    }

                    if (next[1][idx] < next[2][idx] && next[1][idx] < n + 1)
                    {
                        // std::cout << "2\n";
                        dp[idx][state] = std::max(dp[idx][state], 2 + dp[next[1][idx] + 1][1]);
                    }

                    if (next[2][idx] < next[1][idx] && next[2][idx] < n + 1)
                    {
                        // std::cout << "3\n";
                        dp[idx][state] = std::max(dp[idx][state], 2 + dp[next[2][idx] + 1][2]);
                    }
                } else
                {
                    dp[idx][state] = dp[idx + 1][0];
                    if (nextComplete[1][idx] == next[2][idx] && next[2][idx] < n + 1)
                    {
                        // std::cout << "1\n";
                        dp[idx][state] = std::max(dp[idx][state], 1 + dp[next[2][idx] + 1][0]);
                    }

                    if (nextComplete[2][idx] == next[1][idx] && next[1][idx] < n + 1)
                    {
                        // std::cout << "2\n";
                        dp[idx][state] = std::max(dp[idx][state], 1 + dp[next[1][idx] + 1][0]);
                    }

                    if (nextComplete[1][idx] < next[2][idx] && nextComplete[1][idx] < n + 1)
                    {
                        // std::cout << "3\n";
                        dp[idx][state] = std::max(dp[idx][state], 1 + dp[nextComplete[1][idx] + 1][1]);
                    }

                    if (next[2][idx] < nextComplete[1][idx] && next[2][idx] < n + 1)
                    {
                        // std::cout << "4\n";
                        dp[idx][state] = std::max(dp[idx][state], 1 + dp[next[2][idx] + 1][2]);
                    }

                    if (nextComplete[2][idx] < next[1][idx] && nextComplete[2][idx] < n + 1)
                    {
                        // std::cout << "5\n";
                        dp[idx][state] = std::max(dp[idx][state], 1 + dp[nextComplete[2][idx] + 1][2]);
                    }

                    // if (idx == 4) std::cout << "6: " << next[1][idx] << ' ' << nextComplete[2][idx] << ' ' <<  sum[idx - 1] << "\n";
                    if (next[1][idx] < nextComplete[2][idx] && next[1][idx] < n + 1)
                    {
                        dp[idx][state] = std::max(dp[idx][state], 1 + dp[next[1][idx] + 1][1]);
                    }
                }

                // continue;
            }

            if (state == 1)
            {
                dp[idx][state] = dp[idx + 1][0];
                if (nextComplete[2][idx] == next[1][idx] && next[1][idx] < n + 1)
                {
                    dp[idx][state] = std::max(dp[idx][state], 1 + dp[next[1][idx] + 1][0]);
                }

                if (nextComplete[2][idx] < next[1][idx] && nextComplete[2][idx] < n + 1)
                {
                    dp[idx][state] = std::max(dp[idx][state], 1 + dp[nextComplete[2][idx] + 1][2]);
                }

                if (next[1][idx] < nextComplete[2][idx] && next[1][idx] < n + 1)
                {
                    dp[idx][state] = std::max(dp[idx][state], 1 + dp[next[1][idx] + 1][1]);
                }
            }

            if (state == 2)
            {
                dp[idx][state] = dp[idx + 1][0];
                if (nextComplete[1][idx] == next[2][idx] && next[2][idx] < n + 1)
                {
                    dp[idx][state] = std::max(dp[idx][state], 1 + dp[next[2][idx] + 1][0]);
                }

                if (nextComplete[1][idx] < next[2][idx] && nextComplete[1][idx] < n + 1)
                {
                    // if (idx == 3) std::cout << "here: " << sum[idx - 1] << ' ' << nextComplete[1][idx] << "\n";
                    dp[idx][state] = std::max(dp[idx][state], 1 + dp[nextComplete[1][idx] + 1][1]);
                }

                if (next[2][idx] < nextComplete[1][idx] && next[2][idx] < n + 1)
                {
                    dp[idx][state] = std::max(dp[idx][state], 1 + dp[next[2][idx] + 1][2]);
                }
            }

            // std::cout << "dp: " << idx << ' ' << state << " = " << dp[idx][state] << '\n';
        }
    }

    // std::cout << "value: " << value << ' ' << dp[1][0] << '\n';
    return dp[1][0];
}

void solve()
{
    llong s = 0;
    for (int i = 1 ; i <= n ; ++i)
    {
        s += t[1][i] + t[2][i];
    }

    // int ans = 0;
    // std::cout << "sum: " << s << '\n';
    // for (llong d = 1 ; d * d <= s ; ++d)
    // {
    //     if (s % d == 0)
    //     {
    //         ans = std::max(ans, run(d));
    //         if (s / d <= 1e8) ans = std::max(ans, run(s / d));
    //     }
    // }

    std::cout << run(s) << '\n';
}

void input()
{
    std::cin >> n;
    for (int i = 1 ; i <= n ; ++i)
    {
        std::cin >> t[1][i];
    }

    for (int i = 1 ; i <= n ; ++i)
    {
        std::cin >> t[2][i];
    }
}

void fastIOI()
{
    std::ios_base :: sync_with_stdio(0);
    std::cout.tie(nullptr);
    std::cin.tie(nullptr);
}

int main()
{
    fastIOI();
    input();
    solve();

    return 0;
}