#include <algorithm>
#include <iostream>
#include <numeric>
#include <cassert>
#include <vector>
#include <queue>

typedef long long llong;
const int MAXN = 3000 + 10;
const llong INF = 1e18;

int n, m, k;
bool vis[MAXN];
llong dist[MAXN];
std::vector <std::pair <int,int>> g[MAXN];
std::priority_queue <std::pair <llong,int>> pq;

llong run(llong value)
{
    while (pq.size())
    {
        pq.pop();
    }

    std::fill(dist + 1, dist + 1 + n, INF);
    std::fill(vis + 1, vis + 1 + n, false);
    pq.push({0, 1});
    dist[1] = 0;

    while (pq.size())
    {
        auto [d, node] = pq.top();
        pq.pop();

        if (vis[node])
        {
            continue;
        }

        if (node == n)
        {
            break;
        }

        vis[node] = true;
        for (const auto &[u, ed] : g[node])
        {
            if (dist[u] > dist[node] + std::max(ed - value, 0LL))
            {
                dist[u] = dist[node] + std::max(ed - value, 0LL);
                pq.push({-dist[u], u});
            }
        }
    }

    return dist[n] + k * value;
}

void solve()
{
    llong ans = INF;
    for (int i = 1 ; i <= n ; ++i)
    {
        for (const auto &[u, ed] : g[i])
        {
            if (i < u)
            {
                ans = std::min(ans, run(ed));
            }
        }
    }   

    std::cout << ans << '\n';
}

void input()
{
    std::cin >> n >> m >> k;
    for (int i = 1 ; i <= m ; ++i)
    {
        int u, v, d;
        std::cin >> u >> v >> d;
        g[u].push_back({v, d});
        g[v].push_back({u, d});
    }
}

void fastIOI()
{
    std::ios_base :: sync_with_stdio(0);
    std::cout.tie(nullptr);
    std::cin.tie(nullptr);
}

int main()
{
    fastIOI();
    input();
    solve();

    return 0;
}