#include <iostream>
#include <set>
#include <vector>
#include <queue>

using namespace std;

struct edge
{
    int ver;
    int w;
    bool operator < (const edge &e) const
    {
        return w>e.w;
    }
};
struct funedge
{
    int ver;
    int sum;
    int nvals;
    multiset<int>vals;
    bool operator < (const funedge &e) const
    {
        return sum>e.sum;
    }
};
int n, m, k;
vector<edge> v[3001];
void read()
{
    int x, y, t;
    cin>>n>>m>>k;
    for(int i=0;i<m;i++)
    {
        cin>>x>>y>>t;
        v[y].push_back({x, t});
        v[x].push_back({y, t});
    }

}

int d[3001];
bool used[3001];

void init()
{
    for(int i = 2;i <=n;i++)
    {
        d[i] = INT_MAX;
    }
}

void funDijkstra()
{
    init();
    priority_queue<funedge> q;
    q.push({1, 0, 0, {}});
    while(!q.empty())
    {
        funedge e = q.top();
        q.pop();
        if(!used[e.ver])
        {
            used[e.ver] = 1;
            if(d[e.ver]>=e.sum)
            {
                int sz = v[e.ver].size();
                for(int i = 0;i < sz; i++)
                {
                    edge nb = v[e.ver][i];
                    funedge nfedge;
                    nfedge = e;
                    nfedge.ver = nb.ver;
                    if(nfedge.nvals < k)
                    {
                        nfedge.vals.insert(nb.w);
                        nfedge.nvals++;
                        nfedge.sum += nb.w;
                    }
                    else
                    {
                        int mval = *(nfedge.vals.begin());
                        if(mval<nb.w)
                        {
                            nfedge.sum -= mval;
                            nfedge.sum += nb.w;
                            nfedge.vals.erase(nfedge.vals.begin());
                            nfedge.vals.insert(nb.w);
                        }
                    }
                    if(nfedge.sum <= d[nb.ver])
                    {
                        d[nb.ver] = nfedge.sum;
                        q.push(nfedge);
                       // cout<<nb.ver<<endl;
                    }
                }
            }
        }
        //cout<<"SIZE: "<<q.size()<<endl;
    }
    //for(int i = 1;i <=n;i++)
    //{
    //    cout<<d[i]<<endl;
    //}
    cout<<d[n]<<endl;
}

int main()
{
    read();
    funDijkstra();
	return 0;
}
