#include <bits/stdc++.h>
using namespace std;

const int maxn = 3002;
int n, m, k, lead[maxn], sz[maxn], last_edge = 0;
struct edge
{
    int from, to;
    long long price;
    bool operator<(const edge&e)const
    {
        return price < e.price;
    }
};
edge v[maxn];

void read()
{
    ios_base::sync_with_stdio(false);
    cin.tie(NULL);
    cout.tie(NULL);

    cin >> n >> m >> k ;
    int i, from, to;
    long long price;
    for (i=1; i<=m; ++i)
    {
        cin >> from >> to >> price ;
        v[i] = {from, to, price};
    }
}

void init()
{
    int i;
    for (i=1; i<=n; ++i)
    {
        lead[i] = i;
        sz[i] = 1;
    }
    sort(v+1, v+m+1);
}

int find_leader(int x)
{
    if (x == lead[x]) return x;
    return lead[x] = find_leader(lead[x]);
}

bool dsu(int x, int y)
{
    int l1 = find_leader(x);
    int l2 = find_leader(y);
    if (l1 == l2) return false;

    if (sz[l1] < sz[l2])
    {
        lead[l1] = l2;
        sz[l2] += sz[l1];
        sz[l1] = 0;
    }
    else
    {
        lead[l2] = l1;
        sz[l1] += sz[l2];
        sz[l2] = 0;
    }
    return true;
}

void solve()
{
    init();
    int i;
    for (i=1; i<=m; ++i)
    {
        if (dsu(v[i].from, v[i].to) == true)
        {
            last_edge = v[i].price;
            if (find_leader(1) == find_leader(n))
                break;
        }
    }
    cout << last_edge << '\n' ;
}

int main()
{
    read();
    solve();
    return 0;
}

/*

6 7 3
1 2 2
2 3 2
3 4 2
4 5 8
5 1 1
5 6 2
4 6 3

*/