#include <bits/stdc++.h>
using namespace std;

#define endl '\n'
#define MAXN 3001

// {{weight1 + weight2 + ... + weightN}, N}
class cmp {
public:
  bool operator()(pair<vector<int>, int> &p1, pair<vector<int>, int> &p2) {
    int dist1 = 0, dist2 = 0;
    for (int weight : p1.first)
      dist1 += weight;
    for (int weight : p2.first)
      dist2 += weight;

    return dist1 > dist2;
  };
};

int sum(vector<int> &v) {
  int ans = 0;
  for (int e : v)
    ans += e;
  return ans;
}

vector<pair<int, int>> edges[MAXN];
int dist[MAXN];
priority_queue<pair<vector<int>, int>, vector<pair<vector<int>, int>>, cmp> pq;

void dijkstra(int start, int k) {
  fill_n(dist, MAXN, INT_MAX);
  dist[start] = 0;
  pq.push({{}, start});

  while (!pq.empty()) {
    int u = pq.top().second;
    auto path = pq.top().first;
    pq.pop();

    int curr_dist = sum(path);

    if (curr_dist > dist[u])
      continue;

    for (auto &[weight, v] : edges[u]) {
      auto new_path = path;
      if (new_path.size() < k)
        new_path.push_back(weight);
      else {
        new_path.push_back(weight);
        new_path.erase(min_element(new_path.begin(), new_path.end()));
      }

      int new_dist = sum(new_path);
      if (new_dist < dist[v]) {
        dist[v] = new_dist;
        pq.push({new_path, v});
      }
    }
  }
}

int main() {
  ios::sync_with_stdio(false);
  cin.tie(nullptr);

  int n, m, k;
  cin >> n >> m >> k;
  for (int i = 0; i < m; i++) {
    int x, y, t;
    cin >> x >> y >> t;
    edges[x].push_back({t, y});
    edges[y].push_back({t, x});
  }

  dijkstra(1, k);
  cout << (dist[n] == INT_MAX ? -1 : dist[n]) << endl;
  return 0;
}
