#include <bits/stdc++.h>
using namespace std;

#define endl '\n'
#define MAXN 3001

vector<pair<int, int>> edges[MAXN];
int dist[MAXN];

class cmp {
public:
  bool operator()(pair<vector<int>, int> p1, pair<vector<int>, int> &p2) {
    int dist1 = 0, dist2 = 0;
    for (int weight : p1.first)
      dist1 += weight;

    for (int weight : p2.first)
      dist2 += weight;

    return dist1 < dist2;
  };
};

priority_queue<pair<vector<int>, int>, vector<pair<vector<int>, int>>, cmp> pq;

void dijkstra(int start, int k) {
  fill_n(dist, MAXN, INT_MAX);

  dist[start] = 0;
  pq.push({{}, start});

  while (!pq.empty()) {
    int u = pq.top().second;
    vector<int> path = pq.top().first;
    pq.pop();

    int curr_dist = 0;
    for (int weight : path)
      curr_dist += weight;

    if (curr_dist > dist[u])
      continue;

    for (auto &[weight, next] : edges[u]) {
      if (curr_dist + weight < dist[next]) {
        if (path.size() < k)
          path.push_back(weight);
        else if (weight > *max_element(path.begin(), path.end())) {
          path.push_back(weight);
          path.erase(min_element(path.begin(), path.end()));
        }
        pq.push({path, next});
        int new_dist = 0;
        for (int e : path)
          new_dist += e;
        dist[next] = new_dist;
      }
    }
  }
}

int main() {
  ios::sync_with_stdio(false);
  cin.tie(nullptr);

  int n, m, k;
  cin >> n >> m >> k;
  for (int i = 0; i < m; i++) {
    int x, y, t;
    cin >> x >> y >> t;
    edges[x].push_back({t, y});
    edges[y].push_back({t, x});
  }

  dijkstra(1, k);
  cout << dist[n] << endl;
  return 0;
}
