#include <iostream>
#include <queue>
#include <algorithm>
using namespace std;

int n, m, k;
vector<pair<int, int>> adjList[3000];

void read_graph(){
    cin >> n >> m >> k;

    for(int i = 0; i < m; i++){
        int x, y, t;
        cin >> x >> y >> t;

        adjList[x].push_back({y, t});
        adjList[y].push_back({x, t});
    }
}

int cmp(int a, int b){
    return a > b;
}

int bfs(int beg){
    priority_queue<pair<int, int>, vector<pair<int, int>>, greater<pair<int, int>>> pq;

    vector<int> dist(n+1, 1e9), expenses(n+1, 0);
    vector<pair<int, int>> path;

    dist[1] = 0;
    pq.push({beg, 0});


    while(!pq.empty()){
        int dis = pq.top().second;
        int node = pq.top().first;
        pq.pop();

        for(int i = 0; i < adjList[node].size(); i++){
            int nb = adjList[node][i].first;
            int nb_dist = adjList[node][i].second;

            if(nb_dist + dis < dist[nb]){
                dist[nb] = nb_dist + dis;
                pq.push({nb, nb_dist + dis});
                if(expenses[nb] < nb_dist + dis){
                    expenses[nb] += nb_dist + dis;
                }
                path.push_back({nb_dist, nb});
            }
        }
    }
    int result = 0;
    return path[path.size()-1].first;
}

int main(){
    read_graph();
    cout << bfs(1);
    return 0;
}