#include <iostream>
#include <queue>
#include <algorithm>
using namespace std;

int n, m, k;
vector<pair<int, int>> adjList[3000];

void read_graph(){
    cin >> n >> m >> k;

    for(int i = 0; i < m; i++){
        int x, y, t;
        cin >> x >> y >> t;

        adjList[x].push_back({y, t});
        adjList[y].push_back({x, t});
    }
}

int cmp(int a, int b){
    return a > b;
}

int bfs(int beg){
    priority_queue<pair<int, int>, vector<pair<int, int>>, greater<pair<int, int>>> pq;

    vector<int> dist(n+1, 1e9), expenses(n+1, 0), path(n+1, 0);

    for(int i = 1; i <= n; i++){
        path[i] = i;
    }

    dist[1] = 0;
    pq.push({beg, 0});


    while(!pq.empty()){
        int dis = pq.top().second;
        int node = pq.top().first;
        pq.pop();

        for(int i = 0; i < adjList[node].size(); i++){
            int nb = adjList[node][i].first;
            int nb_dist = adjList[node][i].second;

            if(nb_dist + dis < dist[nb]){
                dist[nb] = nb_dist + dis;
                pq.push({nb, nb_dist + dis});
                if(expenses[nb] < nb_dist + dis){
                    expenses[nb] += nb_dist + dis;
                }
                    path[nb] = node;
            }
        }
    }
    
    int result = 0;
    vector<int> final_path;
    vector<int> res_expenses;
    for(int i = 1; i <= n; i++){
        if(path[i] != i){
            final_path.push_back(path[i]);
        }
    }
    for(int i = 1 ; i < expenses.size(); i++){
        for(int j = 0; j < final_path.size(); j++){
            if(i == final_path[j]){
                res_expenses.push_back(expenses[i]);
            }
        }
    }
    sort(res_expenses.begin(), res_expenses.end(), cmp);
    for(int i = 0; i < k; i++){
        result += res_expenses[i];
    }
    return result;
}

int main(){
    read_graph();
    cout << bfs(1);
    return 0;
}