# include <iostream>
using namespace std;

const long long INF=1e18;
const int MAX=5e3+11;

int n;
int a[MAX];
int b[MAX];
long long cost[MAX][MAX];

struct Fenwick
{
    int tree[MAX];

    void init()
    {
        for(int i=1;i<=n;i++) tree[i]=0;
    }

    void update(int u)
    {
        for(int i=u;i<=n;i=(i|(i+1)))
        {
            tree[i]++;
        }
    }

    int query(int u)
    {
        int ans=0;
        for(int i=u;i>=1;i=(i&(i+1))-1)
        {
            ans+=tree[i];
        }

        return ans;
    }

    int query(int l, int r)
    {
        if(l>r) return 0;
        return query(r)-query(l-1);
    }

}tree;

void cost_function()
{
    for(int k=n;k>=1;k--)
    {
        int cnt=0;
        for(int i=1;i<=n;i++)
        {
            if(a[i]<=k)
            {
                cnt++;
                b[cnt]=a[i];
            }
        }

        tree.init();
        for(int i=1;i<=k;i++)
        {
            cost[k][b[i]]=k-i-tree.query(b[i]+1,k);
            tree.update(b[i]);
        }

        for(int last=k-1;last>=1;last--)
        {
            cost[k][last]+=cost[k][last+1];
        }
    }

    /*
    for(int i=1;i<=n;i++)
    {
        for(int last=1;last<=i;last++) cout<<i<<" "<<last<<":"<<cost[i][last]<<"\n";
    }
    */
}

long long dp[MAX];

int main()
{
    ios_base::sync_with_stdio(0);
    cin.tie(0);cout.tie(0);

    cin>>n;
    for(int i=1;i<=n;i++) cin>>a[i];

    cost_function();
    for(int i=1;i<=n;i++) dp[i]=INF;

    for(int i=1;i<=n;i++)
    {
        for(int last=1;last<=i;last++) dp[i]=min(dp[i],cost[i][last]+dp[last-1]);
    }

    cout<<dp[n]<<"\n";

    return 0;
}
