# include <iostream>
# include <vector>
# include <random>
using namespace std;

const int MAX=5e5+11, LOG=18;

mt19937 rng(69420);

int n,q;
int a[MAX];

int st[MAX][LOG];

void sparse_table()
{
    for(int i=1;i<=n;i++)
    {
        st[i][0]=a[i];
    }

    for(int j=1;j<LOG;j++)
    {
        for(int i=1;i<=n;i++)
        {
            if(i-(1<<j)+1<1) continue;

            st[i][j]=max(st[i][j-1],st[i-(1<<(j-1))][j-1]);
        }
    }
}

int get_max(int l, int r)
{
    int j=31-__builtin_clz(r-l+1);
    return max(st[r][j],st[l+(1<<j)-1][j]);
}

int main()
{
    ios_base::sync_with_stdio(0);
    cin.tie(0);cout.tie(0);

    cin>>n>>q;
    for(int i=1;i<=n;i++) cin>>a[i];

    sparse_table();

    for(int i=1;i<=q;i++)
    {
        int l,r,k;
        cin>>l>>r>>k;

        bool f=1;
        for(int j=1;j<=200;j++)
        {
            int id=uniform_int_distribution<int>(l,r)(rng);
            int mx=get_max(l,id);
            if(mx>a[id] and mx+a[id]>k) f=0;
        }

        if(f) cout<<1;
        else cout<<0;

    }
    cout<<"\n";


    return 0;
}



