# include <iostream>
# include <vector>
using namespace std;

const int MAX=1e5+11;

int n,q;
int a[MAX];

struct node
{
    int ans;
    int cnt[101];

    node()
    {
        ans=0;
        for(int i=1;i<=100;i++) cnt[i]=0;
    }

    node friend operator + (node x, node y)
    {
        node c;
        c.ans=max(x.ans,y.ans);
        int mx=0;
        for(int i=100;i>=1;i--)
        {
            if(x.cnt[i]>0)
            {
                mx=i;
                break;
            }
        }

        for(int i=mx-1;i>=1;i--)
        {
            if(y.cnt[i]>0)
            {
                c.ans=max(c.ans,mx+i);
                break;
            }
        }

        for(int i=1;i<=100;i++) c.cnt[i]=x.cnt[i]+y.cnt[i];
        return c;
    }
};

node tree[MAX*4];

void build(int v=1, int l=1, int r=n)
{
    if(l==r)
    {
        tree[v].cnt[a[l]]++;
        return ;
    }

    int mid=(l+r)/2;
    build(v*2,l,mid);
    build(v*2+1,mid+1,r);
    tree[v]=tree[v*2]+tree[v*2+1];
}

node query(int le, int ri, int v=1, int l=1, int r=n)
{
    if(ri<l or r<le) return {};
    if(le<=l and r<=ri) return tree[v];

    int mid=(l+r)/2;
    return query(le,ri,v*2,l,mid)+query(le,ri,v*2+1,mid+1,r);
}

int main()
{
    ios_base::sync_with_stdio(0);
    cin.tie(0);cout.tie(0);

    cin>>n>>q;
    for(int i=1;i<=n;i++) cin>>a[i];

    build();

    for(int i=1;i<=q;i++)
    {
        int l,r,k;
        cin>>l>>r>>k;

        if(k>=query(l,r).ans) cout<<1;
        else cout<<0;
    }
    cout<<"\n";


    return 0;
}



