# include <iostream>
# include <vector>
# include <algorithm>
using namespace std;

const int MAX=5e5+11, LOG=20, INF=1e9;

int n,q;
int a[MAX];

struct node
{
    int l=0,r=0;
    bool f=1;

    node(){}
    node(int _l, int _r, bool _f)
    {
        l=_l;
        r=_r;
        f=_f;
    }

    node friend operator + (node p, node q)
    {
        node c;
        c.l=p.l;
        c.r=q.r;
        c.f=(p.f&q.f);
        if(p.r>q.l) c.f=0;
        return c;
    }
};

node srt[MAX][LOG];
int st[MAX][LOG];

void sparse_table()
{
    for(int i=1;i<=n;i++)
    {
        srt[i][0]={a[i],a[i],1};
        st[i][0]=a[i];
    }

    for(int j=1;j<LOG;j++)
    {
        for(int i=1;i<=n;i++)
        {
            if(i-(1<<j)+1<1) continue;

            st[i][j]=max(st[i][j-1],st[i-(1<<(j-1))][j-1]);
            srt[i][j]=srt[i-(1<<(j-1))][j-1]+srt[i][j-1];
        }
    }
}

int get_max(int l, int r)
{
    int j=31-__builtin_clz(r-l+1);
    return max(st[r][j],st[l+(1<<j)-1][j]);
}

int lift(int l, int r)
{
    /*
    int curr=r, last=INF;
    for(int j=LOG-1;j>=0;j--)
    {
        if(curr-(1<<j)+1>=l and srt[curr][j].f==1 and srt[curr][j].r<=last)
        {
            last=srt[curr][j].l;
            curr-=(1<<j);
        }
    }

    return curr;
    */

    int last=INF;
    for(int i=r;i>=l;i--)
    {
        if(a[i]>last) return i;
        last=a[i];
    }
    return l-1;
}

int lift2(int l, int r, int val)
{
    /*
    int curr=r, mxj=31-__builtin_clz(r-l+1);
    for(int j=mxj;j>=0;j--)
    {
        if(curr-(1<<j)+1>=l and a[curr-(1<<j)+1]>=val) curr-=(1<<j);
    }

    return curr;
    */

    for(int i=r;i>=l;i--) if(val>a[i]) return i;
}

int output[MAX];

int main()
{
    ios_base::sync_with_stdio(0);
    cin.tie(0);cout.tie(0);

    cin>>n>>q;
    for(int i=1;i<=n;i++) cin>>a[i];
    sparse_table();

    for(int i=1;i<=q;i++)
    {
        int l,r,k;
        cin>>l>>r>>k;

        int id=lift(l,r);
        //cout<<"->"<<id<<"\n";
        if(id==l-1) {output[i]=1;continue;}

        int val=get_max(l,id);
        int gr=lift2(id+1,r,val);
        //cout<<gr<<"\n";
        if(k>=val+a[gr]) output[i]=1;
    }

    for(int i=1;i<=q;i++) cout<<output[i];
    cout<<"\n";

    return 0;
}

