# include <iostream>
# include <vector>
# include <algorithm>
using namespace std;

const int MAX=5e5+11, LOG=20, INF=1e9;

int n,q;
int a[MAX];

struct node
{
    int l=0,r=0;
    bool f=1;

    node(){}
    node(int _l, int _r, bool _f)
    {
        l=_l;
        r=_r;
        f=_f;
    }

    node friend operator + (node p, node q)
    {
        node c;
        c.l=p.l;
        c.r=q.r;
        c.f=(p.f&q.f);
        if(p.r>q.l) c.f=0;
        return c;
    }
};

node srt[MAX][LOG];
int st[MAX][LOG];

void sparse_table()
{
    for(int i=1;i<=n;i++)
    {
        srt[i][0]={a[i],a[i],1};
        st[i][0]=a[i];
    }

    for(int j=1;j<LOG;j++)
    {
        for(int i=1;i<=n;i++)
        {
            if(i-(1<<j)+1<1) continue;

            st[i][j]=max(st[i][j-1],st[i-(1<<(j-1))][j]);
            srt[i][j]=srt[i-(1<<(j-1))][j-1]+srt[i][j-1];
        }
    }
}

int get_max(int l, int r)
{
    int j=31-__builtin_clz(r-l+1);
    return max(st[r][j],st[l+(1<<j)-1][j]);
}

int lift(int l, int r)
{
    int curr=r, last=INF;
    for(int j=LOG-1;j>=0;j--)
    {
        if(curr-(1<<j)+1>=l and srt[curr][j].f==1 and srt[curr][j].r<=last)
        {
            last=srt[curr][j].l;
            curr-=(1<<j);
        }
    }

    return curr;
}

struct queries
{
    int id, val, tp;

    bool friend operator < (queries x, queries y)
    {
        if(x.val!=y.val) return x.val>y.val;
        return x.tp<y.tp;
    }
};

struct question
{
    int l,r,k;
};

struct Fenwick
{
    int tree[MAX];

    void init()
    {
        for(int i=1;i<=n;i++) tree[i]=0;
    }

    void update(int u)
    {
        for(int i=u;i<=n;i=(i|(i+1)))
        {
            tree[i]++;
        }
    }

    int query(int u)
    {
        int ans=0;
        for(int i=u;i>=1;i=(i&(i+1))-1)
        {
            ans+=tree[i];
        }

        return ans;
    }

    int query(int l, int r)
    {
        if(l>r) return 0;
        return query(r)-query(l-1);
    }

}tree;

question z[MAX];
int output[MAX];

int main()
{
    ios_base::sync_with_stdio(0);
    cin.tie(0);cout.tie(0);

    cin>>n>>q;
    for(int i=1;i<=n;i++) cin>>a[i];
    sparse_table();

    vector<queries> v;
    for(int i=1;i<=q;i++)
    {
        int l,r,k;
        cin>>l>>r>>k;
        z[i]={l,r,k};

        int id=lift(l,r);
        //cout<<"->"<<id<<"\n";
        if(id==l-1) {output[i]=1;continue;}

        int val=get_max(l,id);
        //cout<<"-->"<<val<<"\n";
        v.push_back({i,val,1});
    }
    for(int i=1;i<=n;i++) v.push_back({i,a[i],0});
    sort(v.begin(),v.end());
    tree.init();

    for(queries t: v)
    {
        if(t.tp==0)
        {
            tree.update(t.id);
            continue;
        }

        int l=z[t.id].l,r=z[t.id].r,k=z[t.id].k;
        int bigger=tree.query(l,r);
        int gr=r-bigger+1;
        //cout<<t.id<<":"<<gr<<"\n";
        if(k>=t.val+a[gr]) output[t.id]=1;
    }

    for(int i=1;i<=q;i++) cout<<output[i];
    cout<<"\n";

    return 0;
}
