#include<bits/stdc++.h>

#define endl '\n'

using namespace std;

typedef long long ll;

const int MAXN = 5e5 + 10;
const int MAXLOG = 22;

int n, q;
int a[MAXN];
int rmq[MAXN][MAXLOG];
int lg[MAXN];

void read()
{
    cin >> n >> q;
    for(int i = 1; i <= n; i++)
    {
        cin >> a[i];
        rmq[i][0] = a[i];
    }
}

void precomp()
{
    for(int i = 2; i <= n; i++)
    {
        lg[i] = lg[i / 2] + 1;
    }

    for(int j = 1; (1 << j) <= n; j++)
    {
        for(int i = 1; i + (1 << j) - 1 <= n; j++)
        {
            rmq[i][j] = max(rmq[i][j - 1], rmq[i + (1 << (j - 1))][j - 1]);
        }
    }
}

int query_rmq(int left, int right)
{
    if(left > right)
        return 0;

    int len = right - left + 1;
    int k = lg[len];

    return max(rmq[left][k], rmq[right - (1 << k) + 1][k]);
}

bool query(int left, int right, int k)
{
    int len = right - left + 1;
    vector < int > v(len + 1, 0);
    vector < pair < int, int > > tmp;

    for(int i = left; i <= right; i++)
    {
        v[i - left + 1] = a[i];
        tmp.push_back({a[i], i});
    }

    sort(tmp.begin(), tmp.end());
    for(int i = 1; i <= len; i++)
    {
        int minval = tmp[i - 1].first;
        int minpos = tmp[i - 1].second;

        //cout << "minval : " << minval << endl;
        //cout << "minpos : " << minpos << endl;

        if(i >= minpos)
            continue;

        int maxval = query_rmq(left, minpos - 1);

        if(maxval == 0)
            continue;

        //cout << "maxval : " << maxval << endl;

        if(minval + maxval > k)
            return false;
    }

    return true;
}

void process_queries()
{
    for(int i = 1; i <= q; i++)
    {
        int left, right, k;
        cin >> left >> right >> k;

        cout << query(left, right, k);
    }
    cout << endl;
}

int main()
{
    ios_base::sync_with_stdio(false);
    cin.tie(nullptr);
    cout.tie(nullptr);

    read();
    precomp();
    process_queries();

    return 0;
}
/*
5 2
1 5 1 8 2
1 3 6
2 5 3
*/
