#include<bits/stdc++.h>

#define endl '\n'

using namespace std;

typedef long long ll;

const int MAXN = 5e5 + 10;
const int MAXLOG = 19;

int n, q;
int a[MAXN];
int spmax[MAXN][MAXLOG];
int spmin[MAXN][MAXLOG];
int lg[MAXN];

void read()
{
    cin >> n >> q;
    for(int i = 1; i <= n; i++)
    {
        cin >> a[i];
        spmax[i][0] = spmin[i][0] = a[i];
    }
}

void precomp()
{
    for(int i = 2; i <= n; i++)
    {
        lg[i] = lg[i / 2] + 1;
    }

    for(int j = 1; (1 << j) <= n; j++)
    {
        for(int i = 1; i + (1 << j) - 1 <= n; i++)
        {
            spmax[i][j] = max(spmax[i][j - 1], spmax[i + (1 << (j - 1))][j - 1]);
            spmin[i][j] = min(spmin[i][j - 1], spmin[i + (1 << (j - 1))][j - 1]);
        }
    }
}

int query_min(int left, int right)
{
    int len = right - left + 1;
    int k = lg[len];

    return min(spmin[left][k], spmin[right - (1 << k) + 1][k]);
}

int query_max(int left, int right)
{
    int len = right - left + 1;
    int k = lg[len];

    return max(spmax[left][k], spmax[right - (1 << k) + 1][k]);
}

bool query(int left, int right, int k)
{
    return query_max(left, right) == query_min(left, right);
}

void process_queries()
{
    for(int i = 1; i <= q; i++)
    {
        int left, right, k;
        cin >> left >> right >> k;

        cout << 0;
    }
    cout << endl;
}

int main()
{
    ios_base::sync_with_stdio(false);
    cin.tie(nullptr);
    cout.tie(nullptr);

    read();
    precomp();
    process_queries();

    return 0;
}
