/**
 ____    ____    ____    __________________    ____    ____    ____
||I ||  ||c ||  ||e ||  ||                ||  ||M ||  ||a ||  ||n ||
||__||  ||__||  ||__||  ||________________||  ||__||  ||__||  ||__||
|/__\|  |/__\|  |/__\|  |/________________\|  |/__\|  |/__\|  |/__\|

*/

#include <iostream>
#include <chrono>
#include <vector>
#include <assert.h>
#include <algorithm>

#define maxn 2000005
#define maxlog 20
#define INF 1000000010
#define LINF 1000000000000000005
#define endl '\n'
#define pb(x) push_back(x)
#define X first
#define Y second
#define control cout<<"passed"<<endl;

using namespace std;


typedef pair <int, int> pii;
typedef long long ll;
typedef pair <ll , ll> pll;
typedef pair <int , ll> pil;
typedef pair <ll , int> pli;
typedef long double pd;


std::chrono::high_resolution_clock::time_point startT, currT;
constexpr double TIME_MULT = 1;

double timePassed()
{
    using namespace std::chrono;
    currT = high_resolution_clock::now();
    double time = duration_cast<duration<double>>(currT - startT).count();
    return time * TIME_MULT;
}


struct snode
{
    bool s;
    int minn , maxx;

    snode(){};
    snode(int _s , int _minn , int _maxx)
    {
        s = _s;
        minn = _minn;
        maxx = _maxx;
    }
};

snode tree[maxn * 4];
int a[maxn];

void build(int node , int l , int r)
{
    if(l == r)
    {
        tree[node] = {1 , a[l] , a[l]};
        return;
    }

    int mid = (l + r) / 2;

    build(node * 2 , l , mid);
    build(node * 2 + 1 , mid + 1 , r);

    tree[node].minn = min(tree[node * 2].minn , tree[node * 2 + 1].minn);
    tree[node].maxx = max(tree[node * 2].maxx , tree[node * 2 + 1].maxx);

    if(tree[node * 2].s == 1 && tree[node * 2 + 1].s == 1 && tree[node * 2].maxx <= tree[node * 2 + 1].minn)
        tree[node].s = 1;
    else
        tree[node].s = 0;
}


snode query(int node , int l , int r , int ql , int qr)
{
    if(qr < l || ql > r)
        return {1 , 1000000000 , -1000000000};
    if(l >= ql && r <= qr)
        return tree[node];

    int mid = (l + r) / 2;

    snode le = query(node * 2 , l , mid , ql , qr);
    snode ri = query(node * 2 + 1 , mid + 1 , r , ql , qr);

    int minn = min(le.minn , ri.minn);
    int maxx = max(le.maxx , ri.maxx);

    bool s;
    if(le.s == 1 && ri.s == 1 && le.maxx <= ri.minn)
        s = 1;
    else
        s = 0;
    return {s , minn , maxx};
}

int n , q;

void print(int node , int l , int r)
{
    cout << l << " - " << r << "-> " << tree[node].s << " " << tree[node].minn << " " << tree[node].maxx << endl;

    if(l == r)
        return;

    int mid = (l + r) / 2;

    print(node * 2 , l , mid);
    print(node * 2 + 1 , mid + 1 , r);
}


void read()
{
    cin >> n >> q;

    for(int i = 1; i <= n; i++)
        cin >> a[i];

    build(1 , 1 , n);
    //print(1 , 1 , n);

    int l , r , k;
    while(q--)
    {
        cin >> l >> r >> k;

        snode pom = query(1 , 1 , n , l , r);
        cout << pom.s;
    }
    cout << endl;
}







int main()
{

/**#ifdef ONLINE_JUDGE /// promeni
    freopen("taxi.in", "r", stdin);
    freopen("taxi.out", "w", stdout);
#endif*/

    ios_base::sync_with_stdio(false);
    cin.tie(nullptr);

    //startT = std::chrono::high_resolution_clock::now();

    read();


    return 0;
}
