#include <iostream>
#include <vector>

using namespace std;

int n;
vector<int> starting;
vector<int> ending;
vector<bool> cnt;

void fastIO()
{
    ios_base::sync_with_stdio(0);
    cin.tie(0);
    cout.tie(0);
}

int main()
{
    fastIO();

    cin >> n;

    vector<pair<int, int>> inp(n);

    int maxn = 0;

    for (int i = 0; i < n; ++i)
    {
        int x, y;
        cin >> x >> y;

        inp[i] = {x, y};
        maxn = max(maxn, y);
    }

    starting.resize(maxn + 5);
    ending.resize(maxn + 5);
    cnt.resize(maxn + 5);

    for (int i = 0; i < n; ++i)
    {
        starting[inp[i].first]++;
        ending[inp[i].second]++;
    }

    for (int i = 1; i <= maxn; ++i)
    {
        starting[i] += starting[i - 1];
        ending[i] += ending[i - 1];
    }

    int ans = 0;

    for (int i = 1; i < maxn; ++i)
    {
        int curr = starting[i] - ending[i];
        ans = max(ans, curr);
    }

    vector<pair<int, int>> v;

    for (int i = 1; i < maxn; ++i)
    {
        int curr = starting[i] - ending[i];

        if (curr == ans)
        {
            cnt[i + 1] = true;
        }
    }

    int ans_len = 0;
    int len = 0;

    for (int i = 1; i <= maxn; ++i)
    {
        if (cnt[i] == 0)
        {
            continue;
        }

        len++;

        if (i == maxn || cnt[i + 1] == 0)
        {
            ans_len += len;
            len = 0;
        }
    }

    cout << ans << endl;
    cout << ans_len << endl;

    return 0;
}
