#include <iostream>
#include <vector>

using namespace std;

const int maxn = 10000000;

int n;
vector<int> starting(maxn + 5);
vector<int> ending(maxn + 5);
vector<bool> cnt(maxn + 5);

void fastIO()
{
    ios_base::sync_with_stdio(0);
    cin.tie(0);
    cout.tie(0);
}

int main()
{
    fastIO();

    cin >> n;

    for (int i = 1; i <= n; ++i)
    {
        int x, y;
        cin >> x >> y;

        starting[x]++;
        ending[y]++;
    }

    for (int i = 1; i <= maxn; ++i)
    {
        starting[i] += starting[i - 1];
        ending[i] += ending[i - 1];
    }

    int ans = 0;

    for (int i = 1; i < maxn; ++i)
    {
        int curr = starting[i] - ending[i];
        ans = max(ans, curr);
    }

    vector<pair<int, int>> v;

    for (int i = 1; i < maxn; ++i)
    {
        int curr = starting[i] - ending[i];

        if (curr == ans)
        {
            cnt[i + 1] = true;
        }
    }

    int ans_len = 0;
    int len = 0;

    for (int i = 1; i <= maxn; ++i)
    {
        if (cnt[i] == 0)
        {
            continue;
        }

        len++;

        if (i == maxn || cnt[i + 1] == 0)
        {
            ans_len += len;
            len = 0;
        }
    }

    cout << ans << endl;
    cout << ans_len << endl;

    return 0;
}
