#include<iostream>
#include<vector>

using namespace std;

int n,q;
int leftForDeduce[100001];
bool allowDeduce[100001];
int brBossOf[100001];
int bossedBy[100001];
vector<int> bossOf[100001];

// Try to substract from all
int deduce(int s) {
	// Climp up
	vector<int> bossChain;
	int boss = s;
	bossChain.push_back(boss);
	while (brBossOf[boss] == 0) {
		boss = bossedBy[boss];
		bossChain.push_back(boss);
	}
	// Climb down
	int total = brBossOf[boss];
	bossChain.pop_back();
	while (boss != s) {
		 brBossOf[boss] = total;
		for (int i = 0; i < bossOf[boss].size(); i++) {
			if (bossOf[boss][i] == bossChain.back()) continue; // skip next in Boss Chain
			total -= (brBossOf[bossOf[boss][i]] + 1);
		}
		total--;
		boss = bossChain.back();
		bossChain.pop_back();
	}
	brBossOf[s] = total;
	return total;
}
void setDeduce(int s) {
	vector<int> bossChain;
	int boss = s;
	bossChain.push_back(boss);
	while (!allowDeduce[boss]) {
		boss = bossedBy[boss];
		bossChain.push_back(boss);
	}
	while (boss != s && leftForDeduce[boss] == 1) {
		allowDeduce[boss];
		boss = bossChain.back();
		bossChain.pop_back();
	}
	if (leftForDeduce[boss] == 1) allowDeduce[boss] = true;
}


int func(int s, bool noDeduce = false) {
	int boss = bossedBy[s];
	if (brBossOf[s] != 0) {
		return brBossOf[s];
	}
	if (allowDeduce[boss]) {
		return deduce(s);
	}

	// Try to add up subordinates
	for (int i = 0; i < bossOf[s].size(); i++) {
		brBossOf[s] += (1 + func(bossOf[s][i]));
	}
	leftForDeduce[boss]--;
	setDeduce(boss);
	return brBossOf[s];
}

int main() {
	cin >> n;
	brBossOf[0] = n;
	allowDeduce[0] = true;
	for (int i = 0; i < n - 1; i++) {
		int u, v;
		cin >> u >> v;
		bossOf[u].push_back(v);
		bossedBy[v] = u;
		leftForDeduce[u]++;
	}
	// Find top boss
	for (int i = 1; i <= n; i++) {
		if (bossedBy[i] == 0) {
			bossOf[0].push_back(i);
			leftForDeduce[0]++;
			break;
		}
	}
	cin >> q;
	for (int i = 0; i < q; i++) {
		int m;
		cin >> m;
		cout << func(m) << endl;
	}
	return 0;
}