#include <stdio.h>
#include <stdlib.h>

int find_lowest(int S, int N, int* numbers);
void sort_array(int* array, size_t size);
void swap(int* n1, int* n2);

int main(){
    int S = 0, N = 0;
    int* numbers;

    do{
        scanf("%d %d", &S, &N);
    }while((S < 0 || S > 20000) && (N < 0 || N > 2000));

    numbers = (int*)malloc(sizeof(int) * N);

    for(int i = 0; i < N; i++){
        do{
            scanf("%d", &numbers[i]);
            getchar();
        }while(numbers[i] > S || numbers[i] <= 0);
    }

    sort_array(numbers, N);

    int result = find_lowest(S, N, numbers);

    for(int i = N - 1; i > 1; i--){
        int temp = find_lowest(S, i, numbers);
        if(result > temp)
            result = temp;
    }

    printf("%d", result);

    return 0;
}

void swap(int* n1, int* n2){
    int temp = *n2;
    *n2 = *n1;
    *n1 = temp;
}

void sort_array(int* array, size_t size){
    for(int i = 0; i < size - 1; i++){
        for(int j = i + 1; j < size; j++){
            if(array[i] > array[j])
                swap(array + i, array + j);
        }
    }
}

int find_lowest(int S, int N, int* numbers){
    int temp = 0, iter = 0, i = N - 1, cycle = 1;

    while(temp != S){
        while(1){
            if(temp + numbers[i] <= S){
                temp += numbers[i];
                iter++;
            }

            else i--;
            if(temp == S) return iter;
        }
    }

    return iter;
}
