#include <algorithm>
#include <iostream>
#include <numeric>
#include <cassert>
#include <vector>

typedef long long llong;
const int MAXN = 100000 + 10;
const int INF  = 1e9;

int n, q;
int s[MAXN];
bool isNotRoot[MAXN];
std::vector <int> g[MAXN];

int dfs(int node)
{
    s[node] = 0;
    for (const int &i : g[node])
    {
        s[node] += 1 + dfs(i);
    }

    return s[node];
}

void solve()
{
    for (int i = 1 ; i <= n ; ++i)
    {
        if (!isNotRoot[i])
        {
            dfs(i);
            break;
        }
    }

    std::cin >> q;
    for (int i = 1 ; i <= q ; ++i)
    {
        int x;
        std::cin >> x;
        std::cout << s[x] << '\n';
    }
}

void read()
{
    int x, y;
    std::cin >> n;
    for (int i = 2 ; i <= n ; ++i)
    {
        std::cin >> x >> y;
        g[x].push_back(y);
        isNotRoot[y] = true;
    }
}

void fastIO()
{
    std::ios_base :: sync_with_stdio(0);
    std::cout.tie(nullptr);
    std::cin.tie(nullptr);
}

int main()
{
    fastIO();
    read();
    solve();

    return 0;
}
