#include <algorithm>
#include <iostream>
#include <numeric>
#include <cassert>
#include <vector>

typedef long long llong;
const int MAXS = 20000 + 10;
const int MAXN = 2000 + 10;
const int INF  = 1e9;

int n, s;
int a[MAXN];
int dp[2][MAXS];
void solve()
{
    for (int i = 1 ; i <= s ; ++i)
    {
        dp[0][i] = INF;
    }

    for (int idx = 1 ; idx <= n ; ++idx)
    {
        for (int sum = 1 ; sum <= s ; ++sum)
        {
            if (sum < a[idx])
            {
                dp[idx&1][sum] = dp[!(idx&1)][sum];
                continue;
            }
            dp[idx&1][sum] = std::min(dp[idx&1][sum - a[idx]] + 1, dp[!(idx&1)][sum]);
        }
    }

    std::cout << dp[s][n&1] << '\n';
}

void read()
{
    std::cin >> s >> n;
    for (int i = 1 ; i <= n ; ++i)
    {
        std::cin >> a[i];
    }
}

void fastIO()
{
    std::ios_base :: sync_with_stdio(0);
    std::cout.tie(nullptr);
    std::cin.tie(nullptr);
}

int main()
{
    fastIO();
    read();
    solve();

    return 0;
}
