#include <algorithm>
#include <iostream>
#include <numeric>
#include <cassert>
#include <vector>

#pragma GCC optimize ("unroll-loops")
#pragma GCC optimize ("O3")

typedef long long llong;
const int MAXS = 20000 + 10;
const int MAXN = 2000 + 10;
const int INF  = 30000;

short n, s;
short a[MAXN];
short dp[MAXS][MAXN];
void solve()
{
    for (short sum = 1 ; sum <= s ; ++sum)
    {
        dp[sum][0] = INF;
        for (short idx = 1 ; idx <= n ; ++idx)
        {
            if (sum < a[idx])
            {
                dp[sum][idx] = dp[sum][idx - 1];
                continue;
            }
            dp[sum][idx] = std::min(dp[sum - a[idx]][idx] + 1, dp[sum][idx - 1]);
        }
    }

    std::cout << dp[s][n] << '\n';
}

void read()
{
    std::cin >> s >> n;
    for (int i = 1 ; i <= n ; ++i)
    {
        std::cin >> a[i];
    }
}

void fastIO()
{
    std::ios_base :: sync_with_stdio(0);
    std::cout.tie(nullptr);
    std::cin.tie(nullptr);
}

int main()
{
    fastIO();
    read();
    solve();

    return 0;
}
