#include <bits/stdc++.h>

typedef long long ll;
typedef long double ld;

const int MAX_N = 1e6 + 42;
const int INF = 1e9;
const int mod = 1e9 + 7;

std::vector<int> v[MAX_N];

bool root[MAX_N];

int subtree[MAX_N];

void dfs( int x, int par ){
    for( auto j : v[x] ){
        dfs( j, x );
        subtree[x] += subtree[j];
    }
    subtree[x] ++;
}

int main () {

    std::ios_base::sync_with_stdio(false); std::cin.tie(NULL);

    int n;
    std::cin>>n;
    for( int i=0 ; i<n-1 ; i++ ){
        int a, b;
        std::cin>>a>>b;
        a--; b--;
        v[a].push_back(b);
        root[b] = true;
    }

    for( int i=0 ; i<n ; i++ ){
        if( !root[i] ){
            dfs(i, 0);
            break;
        }
    }

    int q;
    std::cin>>q;
    while( q-- ){
        int a;
        std::cin>>a;
        a--;
        std::cout<<subtree[a]-1<<"\n";
    }

    return 0;
}
