#include <algorithm>
#include <iostream>
#include <utility>
#include <vector>
#include <queue>
#define endl '\n'
using namespace std;

const int MAXN = 2000;

int n, ans = 0;
int dist[MAXN + 5];
int x[MAXN + 5], y[MAXN + 5];
vector< pair<int, int> > G[MAXN + 5], s[MAXN + 5], t[MAXN + 5];

void Dijkstra(int u)
{
    for (int i = 1; i <= n; ++ i)
    {
        dist[i] = 10000;
    }

    dist[u] = 0;

    priority_queue< pair<int, int> > pq;
    pq.push({0, u});

    while (!pq.empty())
    {
        u = pq.top().second;
        int d = -pq.top().first;
        pq.pop();
        if (d > dist[u]) continue;
        for (auto [v, w] : G[u])
        {
            if (dist[v] > dist[u] + w)
            {
                dist[v] = dist[u] + w;
                pq.push({-dist[v], v});
            }
        }
    }

    for (int i = 1; i <= n; ++ i)
    {
        if (dist[i] < 10000) ans = max(ans, dist[i]);
    }
}

int main()
{
    ios :: sync_with_stdio(false);
    cin.tie(NULL); cout.tie(NULL);

    cin >> n;

    for (int i = 1; i <= n; ++ i)
    {
        cin >> x[i] >> y[i];
        s[x[i]].push_back({y[i], i});
        t[y[i]].push_back({x[i], i});
    }

    for (int i = 1; i <= 1000; ++ i)
    {
        sort(s[i].begin(), s[i].end());
        sort(t[i].begin(), t[i].end());
    }

    for (int i = 1; i <= 1000; ++ i)
    {
        for (int j = 0; j < s[i].size(); ++ j)
        {
            if (j > 0) G[s[i][j].second].push_back({s[i][j - 1].second, s[i][j].first - s[i][j - 1].first});
            if (j + 1 < s[i].size()) G[s[i][j].second].push_back({s[i][j + 1].second, s[i][j + 1].first - s[i][j].first});
        }

        for (int j = 0; j < t[i].size(); ++ j)
        {
            if (j > 0) G[t[i][j].second].push_back({t[i][j - 1].second, t[i][j].first - t[i][j - 1].first});
            if (j + 1< t[i].size()) G[t[i][j].second].push_back({t[i][j + 1].second, t[i][j + 1].first - t[i][j].first});
        }
    }

    for (int i = 1; i <= n; ++ i)
    {
        Dijkstra(i);
    }

    cout << ans << endl;

    return 0;
}
