#include <iostream>
#include <utility>
#include <vector>
#include <queue>
#define endl '\n'
using namespace std;

const int MAXN = 2000;

int n, ans = 0;
int dist[MAXN + 5];
int x[MAXN + 5], y[MAXN + 5];
vector< pair<int, int> > G[MAXN + 5];

void Dijkstra(int u)
{
    for (int i = 1; i <= n; ++ i)
    {
        dist[i] = 1e7;
    }

    dist[u] = 0;

    priority_queue< pair<int, int> > pq;
    pq.push({0, u});

    while (!pq.empty())
    {
        u = pq.top().second;
        int d = -pq.top().first;
        pq.pop();
        ans = max(ans, d);
        if (d > dist[u]) continue;
        for (auto [v, w] : G[u])
        {
            if (dist[v] > dist[u] + w)
            {
                dist[v] = dist[u] + w;
                pq.push({-dist[v], v});
            }
        }
    }
}

int main()
{
    ios :: sync_with_stdio(false);
    cin.tie(NULL); cout.tie(NULL);

    cin >> n;

    for (int i = 1; i <= n; ++ i)
    {
        cin >> x[i] >> y[i];
    }

    for (int i = 1; i <= n; ++ i)
    {
        for (int j = i + 1; j <= n; ++ j)
        {
            if (x[i] == x[j] or y[i] == y[j])
            {
                G[i].push_back({j, abs(x[i] - x[j]) + abs(y[i] - y[j])});
                G[j].push_back({i, abs(x[i] - x[j]) + abs(y[i] - y[j])});
            }
        }
    }

    for (int i = 1; i <= n; ++ i)
    {
        Dijkstra(i);
    }

    cout << ans << endl;

    return 0;
}
