#include <iostream>
#include <algorithm>
#include <vector>
#include <iterator>

using namespace std;


void print_row(int *row, int N) {
    for (int i = 0; i < N; i++) {
        cout << row[i] << " ";
    }
    cout << "\n";
}

void copy_row(int *dest, int *src, int N) {
    for (int i = 0; i < N; i++) {
        dest[i] = src[i];
    }
}

int max_len(int *row, int N) {
    int max_len = row[0];
    for (int i = 0; i < N; i++) {
        max_len = max(row[i], max_len);
    }
    return max_len;
}

int subrow(int *row, int N) {
    vector<int> max_lens;
    for (int len = 2; len <= N; len++) {
        for (int i = 0; i <= N-len; i++) {
            int l = i;
            int r = i+len-1;
            int subrow[len];
            copy_row(subrow, row+l, len);

            int sorted_row[N];
            copy_row(sorted_row, subrow, len);
            sort(sorted_row, sorted_row + len);
            max_lens.push_back(sorted_row[len-2] - len);
            //print_row(sorted_row, len);
        }
    }
    int index = distance(max_lens.begin(), max_element(max_lens.begin(), max_lens.end()));
    //cout << max_lens[index] << "\n";

    return max_lens[index];
}

int main() {

    int N;
    cin >> N;
    int a[N];
    for (int i = 0; i < N; i++) {
        cin >> a[i];
    }

    cout << subrow(a, N) << "\n";

    return 0;
}
