#include <bits/stdc++.h>

#define MAX_N 3000
#define MAX_X 2000

struct Node {
	int x, y;
	int y_next, x_next;
};

int x_first[MAX_X];
int y_first[MAX_X];

Node nodes[MAX_N];

int n;

void make_node(int x, int y, int i) {
	nodes[i] = { x, y, y_first[y], x_first[x] };
	x_first[x] = i;
	y_first[y] = i;
}

int distance(int i, int j) {
	int x = nodes[i].x - nodes[j].x;
	int y = nodes[i].y - nodes[j].y;
	
	if (x < 0) x = -x;
	if (y < 0) y = -y;
	
	assert(x == 0 || y == 0);
	
	return x + y;
}

struct Q_Elem {
	int cost;
	int node;
	bool iterate_by_x; // otherwise iterate by y
	
};

bool operator<(const Q_Elem &a, const Q_Elem &b) {
	return a.cost > b.cost;
}

int dijkstra(int start) {
	bool vis[2][MAX_N];
	memset(vis, false, sizeof vis);
	
	std::priority_queue<Q_Elem> q;
	q.push({0, start, true});
	q.push({0, start, false});
	
	int ans = 0;
	
	while (!q.empty()) {
		int cost = q.top().cost;
		int cur  = q.top().node;
		bool iterate_by_x = q.top().iterate_by_x;
		q.pop();
		
		if (vis[iterate_by_x][cur]) continue;
		vis[iterate_by_x][cur] = true;
			
		ans = std::max(ans, cost);
		
		if (iterate_by_x) {
			for (int i = x_first[nodes[cur].x]; i; i = nodes[i].x_next) {
				if (vis[!iterate_by_x][i]) continue;
				q.push({cost + distance(cur, i), i, !iterate_by_x});
			}
		} else {
			for (int i = y_first[nodes[cur].y]; i; i = nodes[i].y_next) {
				if (vis[!iterate_by_x][i]) continue;
				q.push({cost + distance(cur, i), i, !iterate_by_x});
			}
		}
	}
	
	return ans;
}

int main() {
	std::ios_base::sync_with_stdio(0);
	std::cin.tie(0);
	std::cout.tie(0);
	
	std::cin >> n;
	
	for (int i = 1; i <= n; i += 1) {
		int x, y;
		std::cin >> x >> y;
		make_node(x, y, i);
	}
	
	int ans = 0;
	for (int i = 1; i <= n; i += 1) {
		ans = std::max(ans, dijkstra(i));
	}
	
	std::cout << ans << std::endl;
}

/*
8
1 6
5 5
5 1
2 2
3 2
2 3
3 3
4 3

*/