#include <bits/stdc++.h>

#define MAX_N 3000
#define MAX_X 2000

struct Node {
	int x, y;
	int y_next, x_next;
};

int x_first[MAX_X];
int y_first[MAX_X];

Node nodes[MAX_N];

int n;

void make_node(int x, int y, int i) {
	nodes[i] = { x, y, y_first[y], x_first[x] };
	x_first[x] = i;
	y_first[y] = i;
}

int distance(int i, int j) {
	int x = nodes[i].x - nodes[j].x;
	int y = nodes[i].y - nodes[j].y;
	
	if (x < 0) x = -x;
	if (y < 0) y = -y;
	
	assert(x == 0 || y == 0);
	
	return x + y;
}

int dijkstra(int start) {
	bool vis[MAX_N];
	memset(vis, false, sizeof vis);
	
	std::priority_queue<std::pair<int, int>> q;
	q.push({0, start});
	
	int ans = 0;
	
	while (!q.empty()) {
		int cost = q.top().first;
		int cur  = q.top().second;
		q.pop();
		
		if (vis[cur]) continue;
		vis[cur] = true;
			
		ans = std::max(ans, -cost);
		
		for (int i = x_first[nodes[cur].x]; i; i = nodes[i].x_next) {
			if (vis[i]) continue;
			q.push({cost - distance(cur, i), i});
		}
	
		for (int i = y_first[nodes[cur].y]; i; i = nodes[i].y_next) {
			if (vis[i]) continue;
			q.push({cost - distance(cur, i), i});
		}
	}
	
	return ans;
}

int main() {
	std::ios_base::sync_with_stdio(0);
	std::cin.tie(0);
	std::cout.tie(0);
	
	std::cin >> n;
	
	for (int i = 1; i <= n; i += 1) {
		int x, y;
		std::cin >> x >> y;
		make_node(x, y, i);
	}
	
	int ans = 0;
	for (int i = 1; i <= n; i += 1) {
		ans = std::max(ans, dijkstra(i));
	}
	
	std::cout << ans << std::endl;
}

/*
8
1 6
5 5
5 1
2 2
3 2
2 3
3 3
4 3

*/