#include <bits/stdc++.h>

#define MAX_N 100005

uint64_t n, k, a[MAX_N];

bool find(uint64_t idx, uint64_t want, uint64_t care) {
	if (idx == 0) {
		bool differences = (a[idx] ^ want) & care;
		if (!differences) {
			std::cout << "YES" << std::endl;
			return true;
		}
		return false;
	}
	
	// and
	{
		uint64_t want_next = want & a[idx];
		uint64_t care_next = (want | a[idx]) & care;
		uint64_t problem   = want & ~a[idx] & care;
		if (!problem && find(idx-1, want_next, care_next)) {
			std::cout << "&";
			return true;
		}
	}
	
	// or
	{
		uint64_t want_next = want | a[idx];
		uint64_t care_next = (~want | ~a[idx]) & care;
		uint64_t problem   = ~want & a[idx] & care;
		if (!problem && find(idx-1, want_next, care_next)) {
			std::cout << "|";
			return true;
		}
	}
	
	return false;
}

int main() {
	std::ios_base::sync_with_stdio(0);
	std::cin.tie(0);
	std::cout.tie(0);
	
	int t;
	std::cin >> t;
	
	for (int ti = 0; ti < t; ti += 1) {
		std::cin >> n >> k;
		for (int i = 0; i < n; i += 1) std::cin >> a[i];
		if (find(n-1, k, ~(uint64_t)0)) {
			std::cout << std::endl;
		} else {
			std::cout << "NO" << std::endl;
		}
	}
}
/*
3
4 5
7 4 2 6
4 7
7 4 2 6
4 3
7 6 5 11
*/