#include <iostream>
#include <queue>

#define endl '\n'

using namespace std;

const int MAXN = 2e3 + 3;

pair<int, int> points[MAXN];
vector<pair<int, int>> graph[MAXN];
int min_dist[MAXN];
bool in_queue[MAXN];

int find_paths(int start_point, int n)
{
    for (int i = 0; i < n; ++i)
    {
        min_dist[i] = -1;
        in_queue[i] = false;
    }

    min_dist[start_point] = 0;
    in_queue[start_point] = true;

    queue<int> bfs;
    bfs.push(start_point);

    while (!bfs.empty())
    {
        int currv = bfs.front();
        bfs.pop();

        in_queue[currv] = false;

        for (auto [nextv, dist] : graph[currv])
        {
            if (min_dist[nextv] == -1 or min_dist[currv] + dist < min_dist[nextv])
            {
                min_dist[nextv] = min_dist[currv] + dist;

                if (!in_queue[nextv])
                {
                    bfs.push(nextv);
                    in_queue[nextv] = true;
                }
            }
        }
    }

    int max_min_dist = -1;
    for (int i = 0; i < n; ++i)
    {
        max_min_dist = max(max_min_dist, min_dist[i]);
    }

    return max_min_dist;
}

int main()
{
    ios::sync_with_stdio(false);
    cin.tie(nullptr);

    int n;
    cin >> n;

    for (int i = 0; i < n; ++i)
    {
        cin >> points[i].first >> points[i].second;
    }

    for (int i = 0; i < n; ++i)
    {
        for (int j = i + 1; j < n; ++j)
        {
            int dist = -1;

            if (points[i].first == points[j].first)
            {
                dist = abs(points[i].second - points[j].second);
            }
            else if (points[i].second == points[j].second)
            {
                dist = abs(points[i].first - points[j].first);
            }

            if (dist != -1)
            {
                graph[i].push_back({j, dist});
                graph[j].push_back({i, dist});
            }
        }
    }

    int res = 0;
    for (int i = 0; i < n; ++i) {
        res = max(res, find_paths(i, n));
    }

    cout << res << endl;

    return 0;
}
