#include <iostream>
#include <vector>
#include <algorithm>
#include <string>

#define endl '\n'

using namespace std;

const int MAXN = 1e5 + 3;
const int BITS_SIZE = 63;

int64_t nums[MAXN];

void find_bits(int64_t num, vector<int>& bits)
{
    int pos = 0;
    while (num > 0)
    {
        bits[pos++] = (num % 2ll);
        num /= 2ll;
    }

    for (int i = pos ; i < BITS_SIZE; ++i)
    {
        bits[i] = 0;
    }
}

void solve()
{
    int n;
    int64_t k;
    cin >> n >> k;

    for (int i = 0; i < n; ++i)
    {
        cin >> nums[i];
    }

    vector<int> target_bits(BITS_SIZE, 0);
    find_bits(k, target_bits);

    vector<int> current_bits(BITS_SIZE, 0);

    string operations = "";
    for (int i = n - 1; i > 0; --i)
    {
        find_bits(nums[i], current_bits);

        bool is_and_operation_required = false;
        bool is_or_operation_required = false;

        /*cout << "target:  ";
        for (int j = 0; j < 6; ++j)
        {
            cout << target_bits[j];
        }
        cout << "\ncurrent: ";
        for (int j = 0; j < 6; ++j)
        {
            cout << current_bits[j];
        }
        cout << "\n\n";*/

        for (int j = 0; j < BITS_SIZE; ++j)
        {
            if (target_bits[j] == 0 and current_bits[j] == 1)
            {
                is_and_operation_required = true;
            }
            else if (target_bits[j] == 1 and current_bits[j] == 0)
            {
                is_or_operation_required = true;
            }
        }

        if (is_and_operation_required and is_or_operation_required)
        {
            cout << "NO\n";
            return;
        }

        if (!is_and_operation_required and !is_or_operation_required)
        {
            is_or_operation_required = true;
        }

        if (is_and_operation_required)
        {
            operations += "&";
        }
        else
        {
            operations += "|";
        }

        for (int j = 0; j < BITS_SIZE; ++j)
        {
            if (is_and_operation_required)
            {
                if (target_bits[j] == 0 and current_bits[j] == 0)
                {
                    target_bits[j] = 2;
                }
            }
            else
            {
                if (target_bits[j] == 1 and current_bits[j] == 1)
                {
                    target_bits[j] = 2;
                }
            }
        }
    }

    bool are_bits_ok = true;
    find_bits(nums[0], current_bits);

    for (int i = 0; i < BITS_SIZE; ++i)
    {
        if (target_bits[i] != 2 and target_bits[i] != current_bits[i])
        {
            are_bits_ok = false;
            break;
        }
    }

    if (are_bits_ok)
    {
        reverse(operations.begin(), operations.end());
        cout << "YES\n" << operations << endl;
    }
    else
    {
        cout << "NO\n";
    }
}

int main()
{
    ios::sync_with_stdio(false);
    cin.tie(nullptr);

    int tests;
    cin >> tests;

    for (int test = 0; test < tests; ++test)
    {
        // cout << "Test " << test << ":\n\n";
        solve();
    }

    return 0;
}
