#include <iostream>
#include <vector>

#define endl '\n'

using namespace std;

const int MAXN = 1e5 + 3;
const int BITS_SIZE = 63;

int64_t nums[MAXN];

void find_bits(int64_t num, vector<bool>& bits)
{
    for (int i = 0; num > 0; ++i)
    {
        bits[i] = (num % 2);
        num /= 2;
    }
}

void solve()
{
    int n;
    int64_t k;
    cin >> n >> k;

    for (int i = 0; i < n; ++i)
    {
        cin >> nums[i];
    }

    vector<bool> target_bits(BITS_SIZE, false);
    find_bits(k, target_bits);

    int64_t current_num = nums[0];
    vector<bool> current_bits(BITS_SIZE, false);
    find_bits(current_num, current_bits);

    vector<bool> next_bits(BITS_SIZE, false);

    string operations = "";
    for (int i = 1; i < n; ++i)
    {
        find_bits(nums[i], next_bits);

        bool is_and_operation = false;
        for (int bit = 0; bit < BITS_SIZE; ++bit)
        {
            if (!target_bits[bit] and current_bits[bit] and !next_bits[bit])
            {
                is_and_operation = true;
                break;
            }
        }

        if (is_and_operation)
        {
            operations += "&";
            current_num &= nums[i];
        }
        else
        {
            operations += "|";
            current_num |= nums[i];
        }

        find_bits(current_num, current_bits);
    }

    if (current_num == k)
    {
        cout << "YES\n" << operations << endl;
    }
    else
    {
        cout << "NO\n";
    }
}

int main()
{
    ios::sync_with_stdio(false);
    cin.tie(nullptr);

    int tests;
    cin >> tests;

    for (int test = 0; test < tests; ++test)
    {
        solve();
    }

    return 0;
}
