#include <iostream>
#include <vector>
#include <iostream>

using namespace std;

class Numbers {
private:

    vector <int> numbersVector;
    size_t N; // number of elements in the vector
    vector <vector <int>> subArrays;
    int subArrayMinElements = 2;
    vector <int> max2s; // the max2 for each subArray

public:
    Numbers();
    void displayAllSubArrays();
    void displayNumbers();
    int getLargestMax2AndLenDifference();
private:
    void getAllSubArrays();
    void getMax2s();
};

Numbers::Numbers() {
    do {
        cout << "Enter N: ";
        cin >> N;
        if (N < 2) {
            cout << "N must be >= 2." << endl;
        }
    } while (N < 2);

    numbersVector.resize(N);
    for (size_t i = 0; i < N; i++) {
        cin >> numbersVector[i];
    }
}

void Numbers::getAllSubArrays() {
    for (size_t i = 0; i < N; i++) {
        // get a subArray
        int subArrLength = 0;
        vector <int> subArray;
        for (size_t j = i; j < N; j++) {
            subArray.push_back(numbersVector[j]);
            subArrLength ++;
            if (subArrLength >= subArrayMinElements) {
                subArrays.push_back(subArray);
            }
        }
    }
}

void Numbers::displayNumbers() {
    for (size_t i = 0; i < N; i++) {
        cout << numbersVector[i] << " ";
    }
    cout << endl;
}

void Numbers::displayAllSubArrays() {
    getAllSubArrays();
    for (size_t i = 0; i < subArrays.size(); i++) {
        for (size_t j = 0; j < subArrays[i].size(); j++) {
            cout << subArrays[i][j] << " ";
        }
        cout << endl;
    }
}

void Numbers::getMax2s() {
    max2s.resize(subArrays.size());
    for (size_t i = 0; i < subArrays.size(); i++) {
        size_t maxIndex = 0;
        for (size_t j = 0; j < subArrays[i].size(); j++) {
            if (subArrays[i][j] > subArrays[i][maxIndex]) {
                maxIndex = j;
            }
        }
        // we found the index of the element with the biggest value for the current subArray.
        // now find the next one that is not equal to the current maxIndex.
        size_t max2Index;
        // make sure it's not equal to maxIndex.
        if (subArrays[i].size() - 1 == maxIndex) {
            max2Index = maxIndex - 1;
        }
        else {
            max2Index = maxIndex + 1;
        }
        for (size_t j = 0; j < subArrays[i].size(); j++) {
            if (subArrays[i][j] > subArrays[i][max2Index] && j != maxIndex) {
                max2Index = j;
            }
        }
        // we have the index of the second biggest element
        max2s[i] = subArrays[i][max2Index];
    }
}

int Numbers::getLargestMax2AndLenDifference() {
    getAllSubArrays();
    getMax2s();
    int largestDiff = max2s[0] - subArrays[0].size();
    for (size_t i = 0; i < subArrays.size(); i++) {
        if (max2s[i] - (int)subArrays[i].size() > largestDiff) {
            largestDiff = max2s[i] - subArrays[i].size();
        }
    }
    return largestDiff;
}


int main()
{
    Numbers a;

    cout << a.getLargestMax2AndLenDifference() << endl;
    return 0;
}
