#include <iostream>
#include <vector>
#include <utility>
#include <climits>
#include <algorithm>
#include <cmath>

#define INF_DIST 1000

using namespace std;

pair<int, int> points[2000] = {};
vector<pair<int, int>> edges[2000] = {};

int longestFromPoint(int start, int size) {
	if (edges[start].size() == 0)
		return -1;

	int dist[2000];
	vector<int> queue;

	for (int i = 0; i < size; ++i) {
		dist[i] = i != start ? INF_DIST : 0;
		queue.push_back(i);
	}

	while (queue.size() > 0) {
		int min = 0;
		for (int i = 1; i < queue.size(); ++i) {
			if (dist[queue[i]] < dist[queue[min]])
				min = i;
		}
		// cout << "Start point: " << start << " , Current in queue: " << queue[min] << " with distance from start: " << dist[queue[min]] << endl;
		int curr = queue[min];
		queue.erase(queue.begin() + min, queue.begin() + min + 1);

		if (dist[curr] == INF_DIST) {
			// cout << "Unreachable point detected, interrupting execution" << endl;
			break;
		}
		
		for (pair<int, int> next : edges[curr]) {
			// cout << "Current: " << curr << " (" << dist[curr] << "), Next: " << next.first << " Old dist: " << dist[next.first] << " New dist: " << dist[curr] + next.second << " Updated dist: " << (dist[curr] + next.second < dist[next.first] ? dist[curr] + next.second : dist[next.first]) << endl;
			if (dist[curr] + next.second < dist[next.first])
				dist[next.first] = dist[curr] + next.second;
		}
	}

	int max = -1;
	for (int i = size - 1; i >= 0; --i) {
		if (dist[i] != INF_DIST && dist[i] > max)
			max = dist[i];
	}

	return max;
}

int main() {
	int n;
	cin >> n;
	
	for (int i = 0; i < n; ++i) {
		int x, y;
		cin >> x >> y;
		points[i] = make_pair(x, y);
		edges[i] = vector<pair<int, int>>();
	}

	for (int i = 0; i < n; ++i) {
		for (int j = 0; j < n; ++j) {
			if (i == j)
				continue;
			if (points[j].first == points[i].first) {
				edges[i].push_back(make_pair(j, abs(points[j].second - points[i].second)));
				continue;
			}
			if (points[j].second == points[i].second) {
				edges[i].push_back(make_pair(j, abs(points[j].first - points[i].first)));
				continue;
			}
		}
	}

	
	/* for (auto point : points)
		cout << point.first << " " << point.second << endl;
	for (int i = 0; i < points.size(); ++i) {
		cout << "Analyzing point " << i << " with coordinates (" << points[i].first << ", " << points[i].second << endl;
		for (auto edge : edges[i])
			cout << "Has edge with point " << edge.first << " (" << points[edge.first].first << ", " << points[edge.first].second << " with weight " << edge.second << endl;
	} */
		
	int max = 0;
	for (int i = 0; i < n; ++i) {
		int dist = longestFromPoint(i, n);
		// cout << dist << endl;
		if (dist > max)
			max = dist;
	}

	cout << max;
}