#include <iostream>
#include <vector>
#include <utility>
#include <climits>
#include <algorithm>
#include <cmath>

using namespace std;

vector<pair<int, int>> points;
vector<vector<pair<int, int>>> edges;

int longestFromPoint(int start) {
	if (edges[start].size() == 0)
		return -1;

	vector<int> dist;
	vector<int> queue;

	for (int i = 0; i < points.size(); ++i) {
		dist.push_back(i != start ? INT_MAX : 0);
		queue.push_back(i);
	}

	while (queue.size() > 0) {
		int min = 0;
		for (int i = 1; i < queue.size(); ++i) {
			if (dist[queue[i]] < dist[queue[min]])
				min = i;
		}
		int curr = queue[min];
		queue.erase(queue.begin() + min, queue.begin() + min + 1);

		if (dist[curr] == INT_MAX) {
			break;
		}
		
		for (pair<int, int> next : edges[curr]) {
			if (dist[curr] + next.second < dist[next.first])
				dist[next.first] = dist[curr] + next.second;
		}
	}

	for (int i = dist.size() - 1; i >= 0; --i) {
		if (dist[i] == INT_MAX)
			dist.erase(dist.begin() + i, dist.begin() + i + 1);
	}

	if (dist.size() > 0) {
		sort(dist.begin(), dist.end());
		return dist.back();
	}
	return -1;
}

int main() {
	int n;
	cin >> n;
	
	for (int i = 0; i < n; ++i) {
		int x, y;
		cin >> x >> y;
		points.push_back(make_pair(x, y));
		edges.push_back(vector<pair<int, int>>());
	}

	for (int i = 0; i < n; ++i) {
		for (int j = 0; j < n; ++j) {
			if (i == j)
				continue;
			if (points[j].first == points[i].first) {
				edges[i].push_back(make_pair(j, abs(points[j].second - points[i].second)));
				continue;
			}
			if (points[j].second == points[i].second) {
				edges[i].push_back(make_pair(j, abs(points[j].first - points[i].first)));
				continue;
			}
		}
	}
		
	int max = 0;
	for (int i = 0; i < n; ++i) {
		int dist = longestFromPoint(i);
		if (dist > max)
			max = dist;
	}

	cout << max;
}