#include <iostream>
#include <vector>
#include <algorithm>
#include <queue>
using namespace std;
const int MAXN=2e3+10;
vector <pair <int,int> > px[MAXN], py[MAXN];
vector <pair <int,int> > v[MAXN];
int dist[MAXN][MAXN], x[MAXN], y[MAXN];
void dejkstra(int start) {
    dist[start][start]=0;
    priority_queue <pair <int,int> > q;
    q.push({0,start});
    while (!q.empty()) {
        int x=q.top().second;
        if (-q.top().first!=dist[start][x]) {
            q.pop();
            continue;
        }
        q.pop();
        for (auto i:v[x]) {
            if (dist[start][i.first]==-1 || dist[start][i.first]>dist[start][x]+i.second) {
                dist[start][i.first]=dist[start][x]+i.second;
                q.push({-dist[start][i.first],i.first});
            }
        }
    }
}
int myabs(int a, int b) {
    int ans=a-b;
    if (ans<0) ans=-ans;
    return ans;
}
int main () {
    ios::sync_with_stdio(false);
    cin.tie(nullptr);
    cout.tie(nullptr);
    int n;
    cin >> n;
    for (int i=0;i<n;i++) {
        cin >> x[i] >> y[i];
        px[x[i]].push_back({x[i],i});
        py[y[i]].push_back({x[i],i});
    }
    for (int i=1;i<=1000;i++) {
        if (px[i].size()>0) {
            sort(px[i].begin(),px[i].end());
            for (int j=1;j<px[i].size();j++) {
                int i1, i2, d;
                i1=px[i][j].second; i2=px[i][j-1].second;
                d=myabs(y[i1],y[i2]);
                v[i1].push_back({i2,d});
                v[i2].push_back({i1,d});
            }
        }
        if (py[i].size()>0) {
            sort(py[i].begin(),py[i].end());
            for (int j=1;j<py[i].size();j++) {
                int i1, i2, d;
                i1=py[i][j].second; i2=py[i][j-1].second;
                d=myabs(x[i1],x[i2]);
                v[i1].push_back({i2,d});
                v[i2].push_back({i1,d});
            }
        }
    }
    int ans=0;
    for (int i=0;i<n;i++) {
        for (int j=0;j<n;j++) dist[i][j]=-1;
        dejkstra(i);
        for (int j=0;j<n;j++) {
            if (i==j || dist[i][j]==-1) continue;
            ans=max(ans,dist[i][j]);
        }
    }
    cout << ans << endl;
    return 0;
}
/**
8
1 6
5 5
5 1
2 2
3 2
2 3
3 3
4 3
**/
